/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.baggage;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.baggage.Baggage;
import io.opentelemetry.baggage.BaggageUtils;
import io.opentelemetry.baggage.Entry;
import io.opentelemetry.baggage.EntryMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class BaggageSdk
implements Baggage {
    private final Map<String, Entry> entries;
    @Nullable
    private final Baggage parent;

    private BaggageSdk(Map<String, ? extends Entry> entries, Baggage parent) {
        this.entries = Collections.unmodifiableMap(new HashMap<String, Entry>(Objects.requireNonNull(entries, "entries")));
        this.parent = parent;
    }

    public Collection<Entry> getEntries() {
        HashMap<String, Entry> combined = new HashMap<String, Entry>(this.entries);
        if (this.parent != null) {
            for (Entry entry : this.parent.getEntries()) {
                if (combined.containsKey(entry.getKey())) continue;
                combined.put(entry.getKey(), entry);
            }
        }
        Iterator it = combined.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        return Collections.unmodifiableCollection(combined.values());
    }

    @Nullable
    public String getEntryValue(String entryKey) {
        Entry entry = this.entries.get(entryKey);
        if (entry != null) {
            return entry.getValue();
        }
        return this.parent == null ? null : this.parent.getEntryValue(entryKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BaggageSdk)) {
            return false;
        }
        BaggageSdk distContextSdk = (BaggageSdk)o;
        if (!this.entries.equals(distContextSdk.entries)) {
            return false;
        }
        return this.parent != null ? this.parent.equals(distContextSdk.parent) : distContextSdk.parent == null;
    }

    public int hashCode() {
        int result = this.entries.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    static class Builder
    implements Baggage.Builder {
        @Nullable
        private Baggage parent;
        private boolean noImplicitParent;
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        Builder() {
        }

        public Baggage.Builder setParent(Baggage parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        public Baggage.Builder setParent(Context context) {
            Objects.requireNonNull(context, "context");
            this.setParent(BaggageUtils.getBaggage((Context)context));
            return this;
        }

        public Baggage.Builder setNoParent() {
            this.parent = null;
            this.noImplicitParent = true;
            return this;
        }

        public Baggage.Builder put(String key, String value, EntryMetadata entryMetadata) {
            this.entries.put(Objects.requireNonNull(key, "key"), Entry.create((String)key, (String)Objects.requireNonNull(value, "value"), (EntryMetadata)Objects.requireNonNull(entryMetadata, "entryMetadata")));
            return this;
        }

        public Baggage.Builder remove(String key) {
            this.entries.remove(Objects.requireNonNull(key, "key"));
            if (this.parent != null && this.parent.getEntryValue(key) != null) {
                this.entries.put(key, null);
            }
            return this;
        }

        public BaggageSdk build() {
            if (this.parent == null && !this.noImplicitParent) {
                this.parent = OpenTelemetry.getBaggageManager().getCurrentBaggage();
            }
            return new BaggageSdk(this.entries, this.parent);
        }
    }
}

