/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.trace;

import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final HttpExporterBuilder<TraceRequestMarshaler> builder;
    private final HttpExporter<TraceRequestMarshaler> delegate;

    OtlpHttpSpanExporter(HttpExporterBuilder<TraceRequestMarshaler> builder, HttpExporter<TraceRequestMarshaler> delegate) {
        this.builder = builder;
        this.delegate = delegate;
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public OtlpHttpSpanExporterBuilder toBuilder() {
        return new OtlpHttpSpanExporterBuilder((HttpExporterBuilder<TraceRequestMarshaler>)this.builder.copy());
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        TraceRequestMarshaler exportRequest = TraceRequestMarshaler.create(spans);
        return this.delegate.export((Marshaler)exportRequest, spans.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpSpanExporter{" + this.builder.toString(false) + "}";
    }
}

