/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpMetricExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private final HttpExporterBuilder<MetricsRequestMarshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();

    OtlpHttpMetricExporterBuilder(HttpExporterBuilder<MetricsRequestMarshaler> delegate) {
        this.delegate = delegate;
        delegate.setMeterProvider(MeterProvider::noop);
        OtlpUserAgent.addUserAgentHeader((arg_0, arg_1) -> delegate.addConstantHeaders(arg_0, arg_1));
    }

    OtlpHttpMetricExporterBuilder() {
        this((HttpExporterBuilder<MetricsRequestMarshaler>)new HttpExporterBuilder("otlp", "metric", DEFAULT_ENDPOINT));
    }

    public OtlpHttpMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setConnectTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setConnectTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpHttpMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeaders(key, value);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    OtlpHttpMetricExporterBuilder exportAsJson() {
        this.delegate.exportAsJson();
        return this;
    }

    public OtlpHttpMetricExporter build() {
        return new OtlpHttpMetricExporter(this.delegate, (HttpExporter<MetricsRequestMarshaler>)this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector);
    }
}

