/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.incubator.logs.KeyAnyValue;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AnyValueStatelessMarshaler;
import io.opentelemetry.proto.common.v1.internal.KeyValue;
import java.io.IOException;

public final class KeyValueStatelessMarshaler
implements StatelessMarshaler<KeyAnyValue> {
    public static final KeyValueStatelessMarshaler INSTANCE = new KeyValueStatelessMarshaler();
    private static final byte[] EMPTY_BYTES = new byte[0];

    private KeyValueStatelessMarshaler() {
    }

    public void writeTo(Serializer output, KeyAnyValue value, MarshalerContext context) throws IOException {
        String key = value.getKey();
        if (key.isEmpty()) {
            output.serializeString(KeyValue.KEY, EMPTY_BYTES);
        } else {
            output.serializeStringWithContext(KeyValue.KEY, key, context);
        }
        output.serializeMessageWithContext(KeyValue.VALUE, (Object)value.getAnyValue(), (StatelessMarshaler)AnyValueStatelessMarshaler.INSTANCE, context);
    }

    public int getBinarySerializedSize(KeyAnyValue value, MarshalerContext context) {
        int size = 0;
        String key = value.getKey();
        if (!key.isEmpty()) {
            size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)KeyValue.KEY, (String)key, (MarshalerContext)context);
        }
        return size += StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)KeyValue.VALUE, (Object)value.getAnyValue(), (StatelessMarshaler)AnyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
    }
}

