/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger.thrift;

import com.fasterxml.jackson.jr.ob.JSON;
import io.jaegertracing.thriftjava.Log;
import io.jaegertracing.thriftjava.Span;
import io.jaegertracing.thriftjava.SpanRef;
import io.jaegertracing.thriftjava.SpanRefType;
import io.jaegertracing.thriftjava.Tag;
import io.jaegertracing.thriftjava.TagType;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class Adapter {
    static final AttributeKey<Boolean> KEY_ERROR = AttributeKey.booleanKey((String)"error");
    static final String KEY_LOG_EVENT = "event";
    static final String KEY_EVENT_DROPPED_ATTRIBUTES_COUNT = "otel.event.dropped_attributes_count";
    static final String KEY_DROPPED_ATTRIBUTES_COUNT = "otel.dropped_attributes_count";
    static final String KEY_DROPPED_EVENTS_COUNT = "otel.dropped_events_count";
    static final String KEY_SPAN_KIND = "span.kind";
    static final String KEY_SPAN_STATUS_MESSAGE = "otel.status_message";
    static final String KEY_SPAN_STATUS_CODE = "otel.status_code";
    static final String KEY_INSTRUMENTATION_SCOPE_NAME = "otel.scope.name";
    static final String KEY_INSTRUMENTATION_SCOPE_VERSION = "otel.scope.version";
    static final String KEY_INSTRUMENTATION_LIBRARY_NAME = "otel.library.name";
    static final String KEY_INSTRUMENTATION_LIBRARY_VERSION = "otel.library.version";

    private Adapter() {
    }

    static List<Span> toJaeger(Collection<SpanData> spans) {
        return spans.stream().map(Adapter::toJaeger).collect(Collectors.toList());
    }

    static Span toJaeger(SpanData span) {
        Span target = new Span();
        long traceIdHigh = Adapter.traceIdAsLongHigh(span.getTraceId());
        long traceIdLow = Adapter.traceIdAsLongLow(span.getTraceId());
        target.setTraceIdHigh(traceIdHigh);
        target.setTraceIdLow(traceIdLow);
        target.setSpanId(Adapter.spanIdAsLong(span.getSpanId()));
        target.setOperationName(span.getName());
        target.setStartTime(TimeUnit.NANOSECONDS.toMicros(span.getStartEpochNanos()));
        target.setDuration(TimeUnit.NANOSECONDS.toMicros(span.getEndEpochNanos() - span.getStartEpochNanos()));
        List<Tag> tags = Adapter.toTags(span.getAttributes());
        int droppedAttributes = span.getTotalAttributeCount() - span.getAttributes().size();
        if (droppedAttributes > 0) {
            tags.add(new Tag(KEY_DROPPED_ATTRIBUTES_COUNT, TagType.LONG).setVLong((long)droppedAttributes));
        }
        target.setLogs(Adapter.toJaegerLogs(span.getEvents()));
        int droppedEvents = span.getTotalRecordedEvents() - span.getEvents().size();
        if (droppedEvents > 0) {
            tags.add(new Tag(KEY_DROPPED_EVENTS_COUNT, TagType.LONG).setVLong((long)droppedEvents));
        }
        List<SpanRef> references = Adapter.toSpanRefs(span.getLinks());
        if (span.getParentSpanContext().isValid()) {
            long parentSpanId = Adapter.spanIdAsLong(span.getParentSpanId());
            references.add(new SpanRef(SpanRefType.CHILD_OF, traceIdLow, traceIdHigh, parentSpanId));
            target.setParentSpanId(parentSpanId);
        }
        target.setReferences(references);
        if (span.getKind() != SpanKind.INTERNAL) {
            tags.add(new Tag(KEY_SPAN_KIND, TagType.STRING).setVStr(span.getKind().name().toLowerCase(Locale.ROOT)));
        }
        if (!span.getStatus().getDescription().isEmpty()) {
            tags.add(new Tag(KEY_SPAN_STATUS_MESSAGE, TagType.STRING).setVStr(span.getStatus().getDescription()));
        }
        if (span.getStatus().getStatusCode() != StatusCode.UNSET) {
            tags.add(new Tag(KEY_SPAN_STATUS_CODE, TagType.STRING).setVStr(span.getStatus().getStatusCode().name()));
        }
        tags.add(new Tag(KEY_INSTRUMENTATION_SCOPE_NAME, TagType.STRING).setVStr(span.getInstrumentationScopeInfo().getName()));
        tags.add(new Tag(KEY_INSTRUMENTATION_LIBRARY_NAME, TagType.STRING).setVStr(span.getInstrumentationScopeInfo().getName()));
        if (span.getInstrumentationScopeInfo().getVersion() != null) {
            tags.add(new Tag(KEY_INSTRUMENTATION_SCOPE_VERSION, TagType.STRING).setVStr(span.getInstrumentationScopeInfo().getVersion()));
            tags.add(new Tag(KEY_INSTRUMENTATION_LIBRARY_VERSION, TagType.STRING).setVStr(span.getInstrumentationScopeInfo().getVersion()));
        }
        if (span.getStatus().getStatusCode() == StatusCode.ERROR) {
            tags.add(Adapter.toTag(KEY_ERROR, true));
        }
        target.setTags(tags);
        return target;
    }

    static List<Log> toJaegerLogs(List<EventData> timedEvents) {
        return timedEvents.stream().map(Adapter::toJaegerLog).collect(Collectors.toList());
    }

    static Log toJaegerLog(EventData event) {
        Log result = new Log();
        result.setTimestamp(TimeUnit.NANOSECONDS.toMicros(event.getEpochNanos()));
        result.addToFields(new Tag(KEY_LOG_EVENT, TagType.STRING).setVStr(event.getName()));
        int droppedAttributesCount = event.getDroppedAttributesCount();
        if (droppedAttributesCount > 0) {
            result.addToFields(new Tag(KEY_EVENT_DROPPED_ATTRIBUTES_COUNT, TagType.LONG).setVLong((long)droppedAttributesCount));
        }
        List<Tag> attributeTags = Adapter.toTags(event.getAttributes());
        for (Tag attributeTag : attributeTags) {
            result.addToFields(attributeTag);
        }
        return result;
    }

    static List<Tag> toTags(Attributes attributes) {
        ArrayList<Tag> results = new ArrayList<Tag>();
        attributes.forEach((key, value) -> results.add(Adapter.toTag(key, value)));
        return results;
    }

    static Tag toTag(AttributeKey<?> key, Object value) {
        switch (key.getType()) {
            case STRING: {
                return new Tag(key.getKey(), TagType.STRING).setVStr((String)value);
            }
            case LONG: {
                return new Tag(key.getKey(), TagType.LONG).setVLong(((Long)value).longValue());
            }
            case BOOLEAN: {
                return new Tag(key.getKey(), TagType.BOOL).setVBool(((Boolean)value).booleanValue());
            }
            case DOUBLE: {
                return new Tag(key.getKey(), TagType.DOUBLE).setVDouble(((Double)value).doubleValue());
            }
        }
        try {
            return new Tag(key.getKey(), TagType.STRING).setVStr(JSON.std.asString(value));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error serializing a plain Java object to String. This is a bug in the OpenTelemetry library.", e);
        }
    }

    static List<SpanRef> toSpanRefs(List<LinkData> links) {
        ArrayList<SpanRef> spanRefs = new ArrayList<SpanRef>(links.size());
        for (LinkData link : links) {
            spanRefs.add(Adapter.toSpanRef(link));
        }
        return spanRefs;
    }

    static SpanRef toSpanRef(LinkData link) {
        return new SpanRef(SpanRefType.FOLLOWS_FROM, Adapter.traceIdAsLongLow(link.getSpanContext().getTraceId()), Adapter.traceIdAsLongHigh(link.getSpanContext().getTraceId()), Adapter.spanIdAsLong(link.getSpanContext().getSpanId()));
    }

    private static long traceIdAsLongHigh(String traceId) {
        return new BigInteger(traceId.substring(0, 16), 16).longValue();
    }

    private static long traceIdAsLongLow(String traceId) {
        return new BigInteger(traceId.substring(16, 32), 16).longValue();
    }

    private static long spanIdAsLong(String spanId) {
        return new BigInteger(spanId, 16).longValue();
    }
}

