/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.MultiTextMapPropagator;
import io.opentelemetry.context.propagation.NoopTextMapPropagator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface TextMapPropagator {
    public static TextMapPropagator composite(TextMapPropagator ... propagators) {
        return TextMapPropagator.composite(Arrays.asList(propagators));
    }

    public static TextMapPropagator composite(Iterable<TextMapPropagator> propagators) {
        ArrayList<TextMapPropagator> propagatorsList = new ArrayList<TextMapPropagator>();
        for (TextMapPropagator propagator : propagators) {
            propagatorsList.add(propagator);
        }
        if (propagatorsList.isEmpty()) {
            return NoopTextMapPropagator.getInstance();
        }
        if (propagatorsList.size() == 1) {
            return (TextMapPropagator)propagatorsList.get(0);
        }
        return new MultiTextMapPropagator(propagatorsList);
    }

    public static TextMapPropagator noop() {
        return NoopTextMapPropagator.getInstance();
    }

    public Collection<String> fields();

    public <C> void inject(Context var1, @Nullable C var2, Setter<C> var3);

    public <C> Context extract(Context var1, @Nullable C var2, Getter<C> var3);

    public static interface Getter<C> {
        public Iterable<String> keys(C var1);

        @Nullable
        public String get(@Nullable C var1, String var2);
    }

    public static interface Setter<C> {
        public void set(@Nullable C var1, String var2, String var3);
    }
}

