/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.tooling.ByteArrayUrl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.utility.StreamDrainer;

public abstract class BytecodeWithUrl {
    private BytecodeWithUrl() {
    }

    public abstract URL getUrl();

    public abstract byte[] getBytecode();

    public abstract BytecodeWithUrl cached();

    public static BytecodeWithUrl create(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Copying classes from the bootstrap classloader is not supported!");
        }
        String classFileName = className.replace('.', '/') + ".class";
        return new Lazy(classLoader, classFileName);
    }

    public static BytecodeWithUrl create(Class<?> loadedClass) {
        return BytecodeWithUrl.create(loadedClass.getName(), loadedClass.getClassLoader());
    }

    public static BytecodeWithUrl create(String className, byte[] bytecode) {
        return new ForDynamicType(className, bytecode);
    }

    public static BytecodeWithUrl create(DynamicType.Unloaded<?> dynamicType) {
        String className = dynamicType.getTypeDescription().getName();
        return new ForDynamicType(className, dynamicType.getBytes());
    }

    private static class Lazy
    extends BytecodeWithUrl {
        private final ClassLoader classLoader;
        private final String resourceName;

        private Lazy(ClassLoader classLoader, String resourceName) {
            this.classLoader = classLoader;
            this.resourceName = resourceName;
        }

        @Override
        public URL getUrl() {
            URL url = this.classLoader.getResource(this.resourceName);
            if (url == null) {
                throw new IllegalStateException("Classfile " + this.resourceName + " does not exist in the provided classloader!");
            }
            return url;
        }

        @Override
        public byte[] getBytecode() {
            byte[] byArray;
            block8: {
                InputStream bytecodeStream = this.getUrl().openStream();
                try {
                    byArray = StreamDrainer.DEFAULT.drain(bytecodeStream);
                    if (bytecodeStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bytecodeStream != null) {
                            try {
                                bytecodeStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to read classfile URL", e);
                    }
                }
                bytecodeStream.close();
            }
            return byArray;
        }

        @Override
        public BytecodeWithUrl cached() {
            return new Cached(this);
        }
    }

    private static class ForDynamicType
    extends BytecodeWithUrl {
        private final byte[] byteCode;
        private final String className;
        private volatile URL generatedUrl;

        private ForDynamicType(String className, byte[] byteCode) {
            this.byteCode = byteCode;
            this.className = className;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public URL getUrl() {
            if (this.generatedUrl == null) {
                ForDynamicType forDynamicType = this;
                synchronized (forDynamicType) {
                    if (this.generatedUrl == null) {
                        this.generatedUrl = ByteArrayUrl.create(this.className, this.byteCode);
                    }
                }
            }
            return this.generatedUrl;
        }

        @Override
        public byte[] getBytecode() {
            return this.byteCode;
        }

        @Override
        public BytecodeWithUrl cached() {
            return this;
        }
    }

    private static class Cached
    extends BytecodeWithUrl {
        private final URL classFileUrl;
        private final byte[] cachedByteCode;

        private Cached(Lazy from) {
            this.classFileUrl = from.getUrl();
            this.cachedByteCode = from.getBytecode();
        }

        @Override
        public URL getUrl() {
            return this.classFileUrl;
        }

        @Override
        public byte[] getBytecode() {
            return this.cachedByteCode;
        }

        @Override
        public BytecodeWithUrl cached() {
            return this;
        }
    }
}

