/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.tooling.ShadingRemapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class RemappingUrlConnection
extends URLConnection {
    private static final ShadingRemapper remapper = new ShadingRemapper(ShadingRemapper.rule("#io.opentelemetry.api", "#io.opentelemetry.javaagent.shaded.io.opentelemetry.api"), ShadingRemapper.rule("#io.opentelemetry.context", "#io.opentelemetry.javaagent.shaded.io.opentelemetry.context"), ShadingRemapper.rule("#io.opentelemetry.instrumentation", "#io.opentelemetry.javaagent.shaded.instrumentation"), ShadingRemapper.rule("#io.opentelemetry.semconv", "#io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv"), ShadingRemapper.rule("#io.opentelemetry.extension.aws", "#io.opentelemetry.javaagent.shaded.io.opentelemetry.extension.aws"), ShadingRemapper.rule("#application.io.opentelemetry", "#io.opentelemetry"), ShadingRemapper.rule("#java.util.logging.Logger", "#io.opentelemetry.javaagent.bootstrap.PatchLogger"));
    private final JarFile delegateJarFile;
    private final JarEntry entry;
    private byte[] cacheClassBytes;

    public RemappingUrlConnection(URL url, JarFile delegateJarFile, JarEntry entry) {
        super(url);
        this.delegateJarFile = delegateJarFile;
        this.entry = entry;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.cacheClassBytes == null) {
            this.cacheClassBytes = this.readAndRemap();
        }
        return new ByteArrayInputStream(this.cacheClassBytes);
    }

    private byte[] readAndRemap() throws IOException {
        try {
            InputStream inputStream = this.delegateJarFile.getInputStream(this.entry);
            return RemappingUrlConnection.remapClassBytes(inputStream);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to remap bytes for %s: %s%n", this.url.toString(), e.getMessage()));
        }
    }

    private static byte[] remapClassBytes(InputStream in) throws IOException {
        ClassReader cr = new ClassReader(in);
        ClassWriter cw = new ClassWriter(cr, 0);
        cr.accept((ClassVisitor)new ClassRemapper((ClassVisitor)cw, (Remapper)remapper), 8);
        return cw.toByteArray();
    }

    @Override
    public Permission getPermission() {
        return null;
    }
}

