/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.matcher;

import io.opentelemetry.javaagent.extension.matcher.Utils;
import io.opentelemetry.javaagent.extension.matcher.internal.DelegatingMatcher;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

class SafeErasureMatcher<T extends TypeDefinition>
extends ElementMatcher.Junction.AbstractBase<T>
implements DelegatingMatcher {
    private static final Logger logger = Logger.getLogger(SafeErasureMatcher.class.getName());
    private final ElementMatcher<TypeDescription> matcher;

    public SafeErasureMatcher(ElementMatcher<TypeDescription> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(T target) {
        TypeDescription erasure = SafeErasureMatcher.safeAsErasure(target);
        if (erasure == null) {
            return false;
        }
        return this.matcher.matches((Object)erasure);
    }

    static TypeDescription safeAsErasure(TypeDefinition typeDefinition) {
        try {
            return typeDefinition.asErasure();
        }
        catch (Throwable e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} trying to get erasure for target {1}: {2}", new Object[]{e.getClass().getSimpleName(), Utils.safeTypeDefinitionName(typeDefinition), e.getMessage()});
            }
            return null;
        }
    }

    public String toString() {
        return "safeErasure(" + this.matcher + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeErasureMatcher)) {
            return false;
        }
        SafeErasureMatcher other = (SafeErasureMatcher)obj;
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    @Override
    public ElementMatcher<?> getDelegate() {
        return this.matcher;
    }
}

