/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="otel")
public final class OtelSpringProperties {
    private List<String> propagators = Collections.emptyList();
    private Java java = new Java();
    private Experimental experimental = new Experimental();
    private HasExporters logs = new HasExporters();
    private HasExporters metrics = new HasExporters();
    private HasExporters traces = new HasExporters();
    private Instrumentation instrumentation = new Instrumentation();

    public List<String> getPropagators() {
        return this.propagators;
    }

    public void setPropagators(List<String> propagators) {
        this.propagators = propagators;
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java = java;
    }

    public Experimental getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Experimental experimental) {
        this.experimental = experimental;
    }

    public HasExporters getLogs() {
        return this.logs;
    }

    public void setLogs(HasExporters logs) {
        this.logs = logs;
    }

    public HasExporters getMetrics() {
        return this.metrics;
    }

    public void setMetrics(HasExporters metrics) {
        this.metrics = metrics;
    }

    public HasExporters getTraces() {
        return this.traces;
    }

    public void setTraces(HasExporters traces) {
        this.traces = traces;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void setInstrumentation(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public List<String> getJavaEnabledResourceProviders() {
        return this.java.getEnabled().getResource().getProviders();
    }

    public List<String> getJavaDisabledResourceProviders() {
        return this.java.getDisabled().getResource().getProviders();
    }

    public List<String> getExperimentalMetricsViewConfig() {
        return this.experimental.getMetrics().getView().getConfig();
    }

    public List<String> getExperimentalResourceDisabledKeys() {
        return this.experimental.getResource().getDisabled().getKeys();
    }

    public List<String> getLogsExporter() {
        return this.logs.getExporter();
    }

    public List<String> getMetricsExporter() {
        return this.metrics.getExporter();
    }

    public List<String> getTracesExporter() {
        return this.traces.getExporter();
    }

    public List<String> getHttpClientCaptureRequestHeaders() {
        return this.instrumentation.getHttp().getClient().getCaptureRequestHeaders();
    }

    public List<String> getHttpClientCaptureResponseHeaders() {
        return this.instrumentation.getHttp().getClient().getCaptureResponseHeaders();
    }

    public List<String> getHttpServerCaptureRequestHeaders() {
        return this.instrumentation.getHttp().getServer().getCaptureRequestHeaders();
    }

    public List<String> getHttpServerCaptureResponseHeaders() {
        return this.instrumentation.getHttp().getServer().getCaptureResponseHeaders();
    }

    public List<String> getHttpKnownMethods() {
        return this.instrumentation.getHttp().getKnownMethods();
    }

    public static final class Java {
        private Enabled enabled = new Enabled();
        private Disabled disabled = new Disabled();

        public Enabled getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Enabled enabled) {
            this.enabled = enabled;
        }

        public Disabled getDisabled() {
            return this.disabled;
        }

        public void setDisabled(Disabled disabled) {
            this.disabled = disabled;
        }

        public static final class Enabled {
            private Resource resource = new Resource();

            public Resource getResource() {
                return this.resource;
            }

            public void setResource(Resource resource) {
                this.resource = resource;
            }

            public static final class Resource {
                private List<String> providers = Collections.emptyList();

                public List<String> getProviders() {
                    return this.providers;
                }

                public void setProviders(List<String> providers) {
                    this.providers = providers;
                }
            }
        }

        public static final class Disabled {
            private Resource resource = new Resource();

            public Resource getResource() {
                return this.resource;
            }

            public void setResource(Resource resource) {
                this.resource = resource;
            }

            public static final class Resource {
                private List<String> providers = Collections.emptyList();

                public List<String> getProviders() {
                    return this.providers;
                }

                public void setProviders(List<String> providers) {
                    this.providers = providers;
                }
            }
        }
    }

    public static final class Experimental {
        private Metrics metrics = new Metrics();
        private Resource resource = new Resource();

        public Metrics getMetrics() {
            return this.metrics;
        }

        public void setMetrics(Metrics metrics) {
            this.metrics = metrics;
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public static final class Metrics {
            private View view = new View();

            public View getView() {
                return this.view;
            }

            public void setView(View view) {
                this.view = view;
            }

            public static final class View {
                private List<String> config = Collections.emptyList();

                public List<String> getConfig() {
                    return this.config;
                }

                public void setConfig(List<String> config) {
                    this.config = config;
                }
            }
        }

        public static final class Resource {
            private Disabled disabled = new Disabled();

            public Disabled getDisabled() {
                return this.disabled;
            }

            public void setDisabled(Disabled disabled) {
                this.disabled = disabled;
            }

            public static final class Disabled {
                private List<String> keys = Collections.emptyList();

                public List<String> getKeys() {
                    return this.keys;
                }

                public void setKeys(List<String> keys) {
                    this.keys = keys;
                }
            }
        }
    }

    public static final class HasExporters {
        private List<String> exporter = Collections.emptyList();

        public List<String> getExporter() {
            return this.exporter;
        }

        public void setExporter(List<String> exporter) {
            this.exporter = exporter;
        }
    }

    public static final class Instrumentation {
        private Http http = new Http();

        public Http getHttp() {
            return this.http;
        }

        public void setHttp(Http http) {
            this.http = http;
        }

        public static final class Http {
            private Client client = new Client();
            private Server server = new Server();
            private List<String> knownMethods = Collections.emptyList();

            public Client getClient() {
                return this.client;
            }

            public void setClient(Client client) {
                this.client = client;
            }

            public Server getServer() {
                return this.server;
            }

            public void setServer(Server server) {
                this.server = server;
            }

            public List<String> getKnownMethods() {
                return this.knownMethods;
            }

            public void setKnownMethods(List<String> knownMethods) {
                this.knownMethods = knownMethods;
            }

            public static final class Client {
                private List<String> captureRequestHeaders = Collections.emptyList();
                private List<String> captureResponseHeaders = Collections.emptyList();

                public List<String> getCaptureRequestHeaders() {
                    return this.captureRequestHeaders;
                }

                public void setCaptureRequestHeaders(List<String> captureRequestHeaders) {
                    this.captureRequestHeaders = captureRequestHeaders;
                }

                public List<String> getCaptureResponseHeaders() {
                    return this.captureResponseHeaders;
                }

                public void setCaptureResponseHeaders(List<String> captureResponseHeaders) {
                    this.captureResponseHeaders = captureResponseHeaders;
                }
            }

            public static final class Server {
                private List<String> captureRequestHeaders = Collections.emptyList();
                private List<String> captureResponseHeaders = Collections.emptyList();

                public List<String> getCaptureRequestHeaders() {
                    return this.captureRequestHeaders;
                }

                public void setCaptureRequestHeaders(List<String> captureRequestHeaders) {
                    this.captureRequestHeaders = captureRequestHeaders;
                }

                public List<String> getCaptureResponseHeaders() {
                    return this.captureResponseHeaders;
                }

                public void setCaptureResponseHeaders(List<String> captureResponseHeaders) {
                    this.captureResponseHeaders = captureResponseHeaders;
                }
            }
        }
    }
}

