/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.web;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.ConditionalOnEnabledInstrumentation;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.web.RestTemplateBeanPostProcessor;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.web.RestTemplateInstrumentation;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@ConditionalOnEnabledInstrumentation(module="spring-web")
@ConditionalOnClass(value={RestTemplate.class, RestTemplateCustomizer.class})
@Configuration
public class SpringWebInstrumentationAutoConfiguration {
    @Bean
    static RestTemplateBeanPostProcessor otelRestTemplateBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        return new RestTemplateBeanPostProcessor(openTelemetryProvider, configPropertiesProvider);
    }

    @Bean
    RestTemplateCustomizer otelRestTemplateCustomizer(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        return restTemplate -> RestTemplateInstrumentation.addIfNotPresent(restTemplate, (OpenTelemetry)openTelemetryProvider.getObject(), (ConfigProperties)configPropertiesProvider.getObject());
    }
}

