/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.ProxyConnectionFactory;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.util.Arrays;
import java.util.Collection;

public class ProxyConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String PROXY_DRIVER = "proxy";
    public static final Option<Object> PROXY_LISTENERS = Option.valueOf((String)"proxyListener");
    private static final String COLON = ":";

    public ConnectionFactory create(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        Object protocolValue = connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.PROTOCOL);
        if (!(protocolValue instanceof String)) {
            throw new IllegalArgumentException(String.format("Protocol %s is not String.", protocolValue));
        }
        String protocol = (String)protocolValue;
        if (protocol.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Protocol %s is not valid.", protocol));
        }
        String[] protocols = protocol.split(COLON, 2);
        String driverDelegate = protocols[0];
        String protocolDelegate = protocols.length == 2 ? protocols[1] : "";
        ConnectionFactoryOptions newOptions = ConnectionFactoryOptions.builder().from(connectionFactoryOptions).option(ConnectionFactoryOptions.DRIVER, (Object)driverDelegate).option(ConnectionFactoryOptions.PROTOCOL, (Object)protocolDelegate).build();
        ConnectionFactory connectionFactory = ConnectionFactories.find((ConnectionFactoryOptions)newOptions);
        if (connectionFactory == null) {
            throw new IllegalArgumentException(String.format("Could not find delegating driver %s", driverDelegate));
        }
        ProxyConnectionFactory.Builder builder = ProxyConnectionFactory.builder(connectionFactory);
        if (connectionFactoryOptions.hasOption(PROXY_LISTENERS)) {
            Object proxyListenerOption = connectionFactoryOptions.getValue(PROXY_LISTENERS);
            this.registerProxyListeners(proxyListenerOption, builder);
        }
        return builder.build();
    }

    private void registerProxyListeners(Object optionValue, ProxyConnectionFactory.Builder builder) {
        if (optionValue instanceof Collection) {
            ((Collection)optionValue).forEach(element -> this.registerProxyListeners(element, builder));
        } else if (optionValue instanceof String) {
            Arrays.asList(((String)optionValue).split(",", -1)).forEach(className -> this.registerProxyListenerClassName((String)className, builder));
        } else if (optionValue instanceof Class) {
            this.registerProxyListenerClass((Class)optionValue, builder);
        } else if (optionValue instanceof ProxyExecutionListener) {
            builder.listener((ProxyExecutionListener)optionValue);
        } else {
            throw new IllegalArgumentException(optionValue + " is not a proxy listener instance");
        }
    }

    private void registerProxyListenerClassName(String proxyListenerClassName, ProxyConnectionFactory.Builder builder) {
        Class<?> proxyListenerClass;
        try {
            proxyListenerClass = Class.forName(proxyListenerClassName);
        }
        catch (Exception e) {
            String message = proxyListenerClassName + " is not a valid proxy listener class";
            throw new IllegalArgumentException(message, e);
        }
        this.registerProxyListeners(proxyListenerClass, builder);
    }

    private void registerProxyListenerClass(Class<?> proxyListenerClass, ProxyConnectionFactory.Builder builder) {
        Object proxyListenerInstance;
        try {
            proxyListenerInstance = proxyListenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not instantiate %s", proxyListenerClass), e);
        }
        this.registerProxyListeners(proxyListenerInstance, builder);
    }

    public boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        Object driver = connectionFactoryOptions.getValue(ConnectionFactoryOptions.DRIVER);
        return PROXY_DRIVER.equals(driver);
    }

    public String getDriver() {
        return PROXY_DRIVER;
    }
}

