/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public final class DurationUtil {
    private static final double NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final double MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);

    public static double toSeconds(Duration duration) {
        double epochSecs = duration.getSeconds();
        return epochSecs + (double)duration.getNano() / NANOS_PER_SECOND;
    }

    public static double millisToSeconds(long milliseconds) {
        return (double)milliseconds / MILLIS_PER_SECOND;
    }

    private DurationUtil() {
    }
}

