/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.network;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.DurationUtil;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import jdk.jfr.consumer.RecordedEvent;

public final class NetworkWriteHandler
implements RecordedEventHandler {
    private static final String EVENT_NAME = "jdk.SocketWrite";
    private static final String BYTES_WRITTEN = "bytesWritten";
    private final LongHistogram bytesHistogram;
    private final DoubleHistogram durationHistogram;
    private final Attributes attributes;

    public NetworkWriteHandler(Meter meter) {
        this.bytesHistogram = meter.histogramBuilder("jvm.network.io").setDescription("Network read/write bytes.").setUnit("By").ofLongs().build();
        this.durationHistogram = meter.histogramBuilder("jvm.network.time").setDescription("Network read/write duration.").setUnit("s").build();
        this.attributes = Attributes.of(Constants.ATTR_NETWORK_MODE, (Object)"write");
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.NETWORK_IO_METRICS;
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.bytesHistogram.record(ev.getLong(BYTES_WRITTEN), this.attributes);
        this.durationHistogram.record(DurationUtil.toSeconds(ev.getDuration()), this.attributes);
    }
}

