/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaReceiveRequest;
import javax.annotation.Nullable;

enum KafkaReceiveAttributesExtractor implements AttributesExtractor<KafkaReceiveRequest, Void>
{
    INSTANCE;

    private static final AttributeKey<String> MESSAGING_KAFKA_CONSUMER_GROUP;

    public void onStart(AttributesBuilder attributes, Context parentContext, KafkaReceiveRequest request) {
        String consumerGroup = request.getConsumerGroup();
        if (consumerGroup != null) {
            attributes.put(MESSAGING_KAFKA_CONSUMER_GROUP, (Object)consumerGroup);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, KafkaReceiveRequest request, @Nullable Void unused, @Nullable Throwable error) {
    }

    static {
        MESSAGING_KAFKA_CONSUMER_GROUP = AttributeKey.stringKey((String)"messaging.kafka.consumer.group");
    }
}

