/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.http.internal;

import io.opentelemetry.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import java.util.List;
import javax.annotation.Nullable;

public final class HostAddressAndPortExtractor<REQUEST>
implements AddressAndPortExtractor<REQUEST> {
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    public HostAddressAndPortExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(AddressAndPortExtractor.AddressPortSink sink, REQUEST request) {
        String host = HostAddressAndPortExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "host"));
        if (host == null) {
            return;
        }
        int hostHeaderSeparator = host.indexOf(58);
        if (hostHeaderSeparator == -1) {
            sink.setAddress(host);
        } else {
            sink.setAddress(host.substring(0, hostHeaderSeparator));
            HostAddressAndPortExtractor.setPort(sink, host, hostHeaderSeparator + 1, host.length());
        }
    }

    @Nullable
    private static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }

    private static void setPort(AddressAndPortExtractor.AddressPortSink sink, String header, int start, int end) {
        if (start == end) {
            return;
        }
        try {
            sink.setPort(Integer.parseInt(header.substring(start, end)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

