/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class SemconvStability {
    private static final boolean emitOldDatabaseSemconv;
    private static final boolean emitStableDatabaseSemconv;
    private static final boolean emitOldCodeSemconv;
    private static final boolean emitStableCodeSemconv;
    private static final Map<String, String> dbSystemNameMap;

    public static boolean emitOldDatabaseSemconv() {
        return emitOldDatabaseSemconv;
    }

    public static boolean emitStableDatabaseSemconv() {
        return emitStableDatabaseSemconv;
    }

    public static String stableDbSystemName(String oldDbSystem) {
        String dbSystemName = dbSystemNameMap.get(oldDbSystem);
        return dbSystemName != null ? dbSystemName : oldDbSystem;
    }

    public static boolean isEmitOldCodeSemconv() {
        return emitOldCodeSemconv;
    }

    public static boolean isEmitStableCodeSemconv() {
        return emitStableCodeSemconv;
    }

    private SemconvStability() {
    }

    static {
        boolean oldDatabase = true;
        boolean stableDatabase = false;
        boolean oldCode = true;
        boolean stableCode = false;
        String value = ConfigPropertiesUtil.getString("otel.semconv-stability.opt-in");
        if (value != null) {
            HashSet<String> values = new HashSet<String>(Arrays.asList(value.split(",")));
            if (values.contains("database")) {
                oldDatabase = false;
                stableDatabase = true;
            }
            if (values.contains("database/dup")) {
                oldDatabase = true;
                stableDatabase = true;
            }
            if (values.contains("code")) {
                oldCode = false;
                stableCode = true;
            }
            if (values.contains("code/dup")) {
                oldCode = true;
                stableCode = true;
            }
        }
        emitOldDatabaseSemconv = oldDatabase;
        emitStableDatabaseSemconv = stableDatabase;
        emitOldCodeSemconv = oldCode;
        emitStableCodeSemconv = stableCode;
        dbSystemNameMap = new HashMap<String, String>();
        dbSystemNameMap.put("adabas", "softwareag.adabas");
        dbSystemNameMap.put("intersystems_cache", "intersystems.cache");
        dbSystemNameMap.put("cosmosdb", "azure.cosmosdb");
        dbSystemNameMap.put("db2", "ibm.db2");
        dbSystemNameMap.put("dynamodb", "aws.dynamodb");
        dbSystemNameMap.put("h2", "h2database");
        dbSystemNameMap.put("hanadb", "sap.hana");
        dbSystemNameMap.put("informix", "ibm.informix");
        dbSystemNameMap.put("ingres", "actian.ingres");
        dbSystemNameMap.put("maxdb", "sap.maxdb");
        dbSystemNameMap.put("mssql", "microsoft.sql_server");
        dbSystemNameMap.put("netezza", "ibm.netezza");
        dbSystemNameMap.put("oracle", "oracle.db");
        dbSystemNameMap.put("redshift", "aws.redshift");
        dbSystemNameMap.put("spanner", "gcp.spanner");
    }
}

