/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

final class JdkErrorCauseExtractor
implements ErrorCauseExtractor {
    static final ErrorCauseExtractor INSTANCE = new JdkErrorCauseExtractor();
    @Nullable
    private static final Class<?> COMPLETION_EXCEPTION_CLASS = JdkErrorCauseExtractor.getCompletionExceptionClass();

    @Override
    public Throwable extractCause(Throwable error) {
        if (error.getCause() != null && (error instanceof ExecutionException || JdkErrorCauseExtractor.isInstanceOfCompletionException(error) || error instanceof InvocationTargetException || error instanceof UndeclaredThrowableException)) {
            return this.extractCause(error.getCause());
        }
        return error;
    }

    private static boolean isInstanceOfCompletionException(Throwable error) {
        return COMPLETION_EXCEPTION_CLASS != null && COMPLETION_EXCEPTION_CLASS.isInstance(error);
    }

    @Nullable
    private static Class<?> getCompletionExceptionClass() {
        try {
            return Class.forName("java.util.concurrent.CompletionException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private JdkErrorCauseExtractor() {
    }
}

