/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import org.jspecify.annotations.Nullable;

public class OperationStartResult<R> {
    private final @Nullable R syncResult;
    private final @Nullable String asyncOperationToken;

    public static <R> Builder<R> newSyncBuilder(@Nullable R value) {
        return new Builder().setSyncResult(value);
    }

    public static <R> Builder<R> newAsyncBuilder(String operationToken) {
        return new Builder().setAsyncOperationToken(operationToken);
    }

    public static <R> Builder<R> newBuilder(OperationStartResult<R> request) {
        return new Builder(request);
    }

    public static <R> OperationStartResult<R> sync(@Nullable R value) {
        return OperationStartResult.newSyncBuilder(value).build();
    }

    public static <R> OperationStartResult<R> async(String operationToken) {
        return OperationStartResult.newAsyncBuilder(operationToken).build();
    }

    private OperationStartResult(@Nullable R syncResult, @Nullable String asyncOperationToken) {
        this.syncResult = syncResult;
        this.asyncOperationToken = asyncOperationToken;
    }

    public boolean isSync() {
        return this.asyncOperationToken == null;
    }

    public @Nullable R getSyncResult() {
        return this.syncResult;
    }

    public @Nullable String getAsyncOperationToken() {
        return this.asyncOperationToken;
    }

    public static class Builder<R> {
        private R syncResult;
        private @Nullable String asyncOperationToken;

        private Builder() {
        }

        private Builder(OperationStartResult<R> result) {
            this.syncResult = ((OperationStartResult)result).syncResult;
            this.asyncOperationToken = ((OperationStartResult)result).asyncOperationToken;
        }

        private Builder<R> setSyncResult(R syncResult) {
            this.syncResult = syncResult;
            return this;
        }

        private Builder<R> setAsyncOperationToken(String asyncOperationToken) {
            if (asyncOperationToken == null || asyncOperationToken.isEmpty()) {
                throw new IllegalArgumentException("Operation Token cannot be null or empty");
            }
            this.asyncOperationToken = asyncOperationToken;
            return this;
        }

        public OperationStartResult<R> build() {
            if (this.syncResult != null && this.asyncOperationToken != null) {
                throw new IllegalStateException("Cannot have both sync result and async operation token");
            }
            return new OperationStartResult(this.syncResult, this.asyncOperationToken);
        }
    }
}

