/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import io.nexusrpc.Link;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OperationStartDetails {
    private final @Nullable String callbackUrl;
    private final Map<String, String> callbackHeaders;
    private final String requestId;
    private final List<Link> links;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OperationStartDetails details) {
        return new Builder(details);
    }

    private OperationStartDetails(@Nullable String callbackUrl, Map<String, String> callbackHeaders, String requestId, List<Link> links) {
        this.callbackUrl = callbackUrl;
        this.callbackHeaders = callbackHeaders;
        this.requestId = requestId;
        this.links = links;
    }

    public @Nullable String getCallbackUrl() {
        return this.callbackUrl;
    }

    public Map<String, String> getCallbackHeaders() {
        return this.callbackHeaders;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public static class Builder {
        private @Nullable String callbackUrl;
        private final Map<String, String> callbackHeaders;
        private @Nullable String requestId;
        private final List<Link> links;

        private Builder() {
            this.callbackHeaders = new HashMap<String, String>();
            this.links = new ArrayList<Link>();
        }

        private Builder(OperationStartDetails details) {
            this.callbackUrl = details.callbackUrl;
            this.callbackHeaders = new HashMap<String, String>(details.callbackHeaders);
            this.requestId = details.requestId;
            this.links = new ArrayList<Link>(details.links);
        }

        public Builder setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Map<String, String> getCallbackHeaders() {
            return this.callbackHeaders;
        }

        public Builder putCallbackHeader(String key, String value) {
            this.callbackHeaders.put(key, value);
            return this;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder addLink(Link link) {
            this.links.add(link);
            return this;
        }

        public List<Link> getLinks() {
            return this.links;
        }

        public OperationStartDetails build() {
            Objects.requireNonNull(this.requestId, "Request ID required");
            return new OperationStartDetails(this.callbackUrl, Collections.unmodifiableMap(new HashMap<String, String>(this.callbackHeaders)), this.requestId, Collections.unmodifiableList(new ArrayList<Link>(this.links)));
        }
    }
}

