/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import io.nexusrpc.OperationDefinition;
import io.nexusrpc.OperationInfo;
import io.nexusrpc.OperationStillRunningException;
import io.nexusrpc.OperationUnsuccessfulException;
import io.nexusrpc.Serializer;
import io.nexusrpc.handler.Handler;
import io.nexusrpc.handler.HandlerInputContent;
import io.nexusrpc.handler.HandlerResultContent;
import io.nexusrpc.handler.OperationCancelDetails;
import io.nexusrpc.handler.OperationContext;
import io.nexusrpc.handler.OperationFetchInfoDetails;
import io.nexusrpc.handler.OperationFetchResultDetails;
import io.nexusrpc.handler.OperationHandler;
import io.nexusrpc.handler.OperationHandlerException;
import io.nexusrpc.handler.OperationMiddleware;
import io.nexusrpc.handler.OperationStartDetails;
import io.nexusrpc.handler.OperationStartResult;
import io.nexusrpc.handler.ServiceImplInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ServiceHandler
implements Handler {
    private final Map<String, ServiceImplInstance> instances;
    private final Serializer serializer;
    private final List<OperationMiddleware> middlewares;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ServiceHandler handler) {
        return new Builder(handler);
    }

    private ServiceHandler(Map<String, ServiceImplInstance> instances, Serializer serializer, List<OperationMiddleware> middlewares) {
        this.instances = instances;
        this.serializer = serializer;
        this.middlewares = middlewares;
    }

    public Map<String, ServiceImplInstance> getInstances() {
        return this.instances;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public List<OperationMiddleware> getOperationMiddlewares() {
        return this.middlewares;
    }

    private OperationHandler<Object, Object> interceptOperationHandler(OperationContext context, OperationHandler<Object, Object> rootHandler) {
        OperationHandler<Object, Object> handler = rootHandler;
        ListIterator<OperationMiddleware> li = this.middlewares.listIterator(this.middlewares.size());
        while (li.hasPrevious()) {
            handler = li.previous().intercept(context, handler);
        }
        return handler;
    }

    @Override
    public OperationStartResult<HandlerResultContent> startOperation(OperationContext context, OperationStartDetails details, HandlerInputContent input) throws OperationUnsuccessfulException {
        Object inputObject;
        ServiceImplInstance instance = this.instances.get(context.getService());
        if (instance == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        OperationHandler<Object, Object> handler = instance.getOperationHandlers().get(context.getOperation());
        if (handler == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        OperationHandler<Object, Object> interceptedHandler = this.interceptOperationHandler(context, handler);
        OperationDefinition definition = instance.getDefinition().getOperations().get(context.getOperation());
        try {
            Serializer.Content.Builder contentBuilder = Serializer.Content.newBuilder();
            contentBuilder.setData(input.consumeBytes());
            contentBuilder.getHeaders().putAll(input.getHeaders());
            inputObject = this.serializer.deserialize(contentBuilder.build(), definition.getInputType());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed deserializing input", e);
        }
        OperationStartResult<Object> result = interceptedHandler.start(context, details, inputObject);
        if (!result.isSync()) {
            return result;
        }
        return OperationStartResult.sync(this.resultToContent(result.getSyncResult()));
    }

    @Override
    public HandlerResultContent fetchOperationResult(OperationContext context, OperationFetchResultDetails details) throws OperationStillRunningException, OperationUnsuccessfulException {
        ServiceImplInstance instance = this.instances.get(context.getService());
        if (instance == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        OperationHandler<Object, Object> handler = instance.getOperationHandlers().get(context.getOperation());
        if (handler == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        Object result = this.interceptOperationHandler(context, handler).fetchResult(context, details);
        return this.resultToContent(result);
    }

    private HandlerResultContent resultToContent(Object result) {
        try {
            Serializer.Content output = this.serializer.serialize(result);
            HandlerResultContent.Builder contentBuilder = HandlerResultContent.newBuilder();
            contentBuilder.setData(output.getData());
            contentBuilder.getHeaders().putAll(output.getHeaders());
            return contentBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed serializing result", e);
        }
    }

    @Override
    public OperationInfo fetchOperationInfo(OperationContext context, OperationFetchInfoDetails details) {
        ServiceImplInstance instance = this.instances.get(context.getService());
        if (instance == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        OperationHandler<Object, Object> handler = instance.getOperationHandlers().get(context.getOperation());
        if (handler == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        return this.interceptOperationHandler(context, handler).fetchInfo(context, details);
    }

    @Override
    public void cancelOperation(OperationContext context, OperationCancelDetails details) {
        ServiceImplInstance instance = this.instances.get(context.getService());
        if (instance == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        OperationHandler<Object, Object> handler = instance.getOperationHandlers().get(context.getOperation());
        if (handler == null) {
            throw ServiceHandler.newUnrecognizedOperationException(context.getService(), context.getOperation());
        }
        this.interceptOperationHandler(context, handler).cancel(context, details);
    }

    private static OperationHandlerException newUnrecognizedOperationException(String service, String operation) {
        return new OperationHandlerException(OperationHandlerException.ErrorType.NOT_FOUND, "Unrecognized service " + service + " or operation " + operation);
    }

    public static class Builder {
        private final List<ServiceImplInstance> instances;
        private @Nullable Serializer serializer;
        private List<OperationMiddleware> middlewares;

        private Builder() {
            this.instances = new ArrayList<ServiceImplInstance>();
            this.middlewares = new ArrayList<OperationMiddleware>();
        }

        private Builder(ServiceHandler handler) {
            this.instances = new ArrayList(handler.instances.values());
            this.serializer = handler.serializer;
            this.middlewares = new ArrayList<OperationMiddleware>(handler.middlewares);
        }

        public List<ServiceImplInstance> getInstances() {
            return this.instances;
        }

        public Builder addInstance(ServiceImplInstance instance) {
            this.instances.add(instance);
            return this;
        }

        public Builder setSerializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder addOperationMiddleware(OperationMiddleware middleware) {
            this.middlewares.add(middleware);
            return this;
        }

        public List<OperationMiddleware> getOperationMiddlewares() {
            return this.middlewares;
        }

        public ServiceHandler build() {
            if (this.instances.isEmpty()) {
                throw new IllegalStateException("No service instances defined");
            }
            Objects.requireNonNull(this.serializer, "Serializer required");
            HashMap<String, ServiceImplInstance> instancesByName = new HashMap<String, ServiceImplInstance>(this.instances.size());
            for (ServiceImplInstance instance : this.instances) {
                if (instancesByName.containsKey(instance.getDefinition().getName())) {
                    throw new IllegalStateException("Multiple instances registered for service name '" + instance.getDefinition().getName() + "'");
                }
                instancesByName.put(instance.getDefinition().getName(), instance);
            }
            return new ServiceHandler(Collections.unmodifiableMap(instancesByName), this.serializer, Collections.unmodifiableList(new ArrayList<OperationMiddleware>(this.middlewares)));
        }
    }
}

