/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import io.nexusrpc.OperationDefinition;
import io.nexusrpc.ServiceDefinition;
import io.nexusrpc.handler.OperationHandler;
import io.nexusrpc.handler.OperationImpl;
import io.nexusrpc.handler.ServiceImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.jspecify.annotations.Nullable;

public class ServiceImplInstance {
    private final ServiceDefinition definition;
    private final Map<String, OperationHandler<Object, Object>> operationHandlers;

    public static ServiceImplInstance fromInstance(Object instance) {
        ServiceDefinition serviceDefinition;
        ServiceImpl serviceImpl = instance.getClass().getDeclaredAnnotation(ServiceImpl.class);
        if (serviceImpl == null) {
            throw new IllegalArgumentException("Missing @ServiceImpl annotation");
        }
        if (serviceImpl.service() == null) {
            throw new IllegalArgumentException("@ServiceImpl annotation missing service class");
        }
        try {
            serviceDefinition = ServiceDefinition.fromClass(serviceImpl.service());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed loading @ServiceImpl class " + serviceImpl.service(), e);
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        ServiceImplInstance.collectClassMethods(instance.getClass(), methods);
        Builder builder = ServiceImplInstance.newBuilder().setDefinition(serviceDefinition);
        for (Method method : methods) {
            OperationImpl operationImpl = method.getDeclaredAnnotation(OperationImpl.class);
            if (operationImpl == null) continue;
            try {
                ServiceImplInstance.addOperationHandler(builder, serviceDefinition, instance, method);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed obtaining operation handler from " + method.getName(), e);
            }
        }
        return builder.build();
    }

    private static void addOperationHandler(Builder builder, ServiceDefinition serviceDefinition, Object instance, Method method) {
        Object handler;
        if (method.getParameterCount() > 0) {
            throw new IllegalArgumentException("Cannot have any parameters");
        }
        if (method.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Cannot be generic");
        }
        if (method.getExceptionTypes().length > 0) {
            throw new IllegalArgumentException("Cannot have throws clause");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Must be public");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Cannot be static");
        }
        OperationDefinition operationDefinition = serviceDefinition.getOperations().values().stream().filter(o -> method.getName().equals(o.getMethodName())).findAny().orElse(null);
        if (operationDefinition == null) {
            throw new IllegalStateException("Mo matching @Operation on the service interface");
        }
        try {
            handler = method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Obtaining handler failed", e);
        }
        Objects.requireNonNull(handler);
        if (!(handler instanceof OperationHandler)) {
            throw new RuntimeException("Expected handler to be instance of OperationHandler, was " + handler.getClass());
        }
        if (builder.operationHandlers.containsKey(operationDefinition.getName())) {
            throw new RuntimeException("Multiple overloads with @OperationImpl");
        }
        builder.putOperationHandler(operationDefinition.getName(), (OperationHandler)handler);
    }

    private static void collectClassMethods(Class<?> clazz, List<Method> methods) {
        Arrays.stream(clazz.getDeclaredMethods()).filter(method -> methods.stream().noneMatch(superMethod -> superMethod.getName().equals(method.getName()) && Arrays.equals(superMethod.getParameterTypes(), method.getParameterTypes()))).forEach(methods::add);
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            ServiceImplInstance.collectClassMethods(clazz.getSuperclass(), methods);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ServiceImplInstance instance) {
        return new Builder(instance);
    }

    private ServiceImplInstance(ServiceDefinition definition, Map<String, OperationHandler<Object, Object>> operationHandlers) {
        this.definition = definition;
        this.operationHandlers = operationHandlers;
    }

    public ServiceDefinition getDefinition() {
        return this.definition;
    }

    public Map<String, OperationHandler<Object, Object>> getOperationHandlers() {
        return this.operationHandlers;
    }

    public static class Builder {
        private @Nullable ServiceDefinition definition;
        private final Map<String, OperationHandler<Object, Object>> operationHandlers;

        private Builder() {
            this.operationHandlers = new HashMap<String, OperationHandler<Object, Object>>();
        }

        private Builder(ServiceImplInstance instance) {
            this.definition = instance.definition;
            this.operationHandlers = new HashMap<String, OperationHandler<Object, Object>>(instance.operationHandlers);
        }

        public Builder setDefinition(ServiceDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Map<String, OperationHandler<Object, Object>> getOperationHandlers() {
            return this.operationHandlers;
        }

        public Builder putOperationHandler(String operationName, OperationHandler<?, ?> operationHandler) {
            this.operationHandlers.put(operationName, operationHandler);
            return this;
        }

        public ServiceImplInstance build() {
            Objects.requireNonNull(this.definition, "Service definition required");
            if (this.operationHandlers.isEmpty()) {
                throw new IllegalStateException("No operation handlers defined");
            }
            TreeSet<String> forDiff = new TreeSet<String>(this.definition.getOperations().keySet());
            forDiff.removeAll(this.operationHandlers.keySet());
            if (!forDiff.isEmpty()) {
                throw new IllegalStateException("Missing handlers for service operations: " + String.join((CharSequence)", ", forDiff));
            }
            forDiff = new TreeSet<String>(this.operationHandlers.keySet());
            forDiff.removeAll(this.definition.getOperations().keySet());
            if (!forDiff.isEmpty()) {
                throw new IllegalStateException("Operation handlers don't correspond to service operations: " + String.join((CharSequence)", ", forDiff));
            }
            return new ServiceImplInstance(this.definition, Collections.unmodifiableMap(new HashMap<String, OperationHandler<Object, Object>>(this.operationHandlers)));
        }
    }
}

