/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class HandlerResultContent {
    private final byte @Nullable [] dataBytes;
    private final @Nullable InputStream dataStream;
    private final Map<String, String> headers;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(HandlerResultContent content) {
        return new Builder(content);
    }

    private HandlerResultContent(byte @Nullable [] dataBytes, @Nullable InputStream dataStream, Map<String, String> headers) {
        this.dataBytes = dataBytes;
        this.dataStream = dataStream;
        this.headers = headers;
    }

    public byte @Nullable [] getDataBytes() {
        return this.dataBytes;
    }

    public @Nullable InputStream getDataStream() {
        return this.dataStream;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerResultContent that = (HandlerResultContent)o;
        return Objects.deepEquals(this.dataBytes, that.dataBytes) && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.dataBytes), this.dataStream, this.headers);
    }

    public static class Builder {
        private byte @Nullable [] dataBytes;
        private @Nullable InputStream dataStream;
        private final Map<String, String> headers;

        private Builder() {
            this.headers = new HashMap<String, String>();
        }

        private Builder(HandlerResultContent content) {
            this.dataBytes = content.dataBytes;
            this.dataStream = content.dataStream;
            this.headers = new HashMap<String, String>(content.headers);
        }

        public Builder setData(byte[] data) {
            this.dataBytes = data;
            this.dataStream = null;
            return this;
        }

        public Builder setData(InputStream data) {
            this.dataBytes = null;
            this.dataStream = data;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public HandlerResultContent build() {
            if (this.dataStream == null) {
                Objects.requireNonNull(this.dataBytes, "Data required");
            }
            return new HandlerResultContent(this.dataBytes, this.dataStream, Collections.unmodifiableMap(new HashMap<String, String>(this.headers)));
        }
    }
}

