/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import io.nexusrpc.Operation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OperationDefinition {
    private final String name;
    private final @Nullable String methodName;
    private final Type inputType;
    private final Type outputType;

    static OperationDefinition fromMethod(Method method) {
        Operation operation = method.getDeclaredAnnotation(Operation.class);
        if (operation == null) {
            throw new IllegalArgumentException("Missing @Operation annotation");
        }
        if (method.getParameterCount() > 1) {
            throw new IllegalArgumentException("Can have no more than one parameter");
        }
        if (method.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Cannot be generic");
        }
        if (method.getExceptionTypes().length > 0) {
            throw new IllegalArgumentException("Cannot have throws clause");
        }
        if (method.isDefault() && !method.isSynthetic()) {
            throw new IllegalArgumentException("Cannot have default implementation");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Cannot be static");
        }
        return OperationDefinition.newBuilder().setName(operation.name().isEmpty() ? method.getName() : operation.name()).setMethodName(method.getName()).setInputType(method.getParameterCount() == 0 ? Void.TYPE : method.getParameterTypes()[0]).setOutputType(method.getGenericReturnType()).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OperationDefinition definition) {
        return new Builder(definition);
    }

    private OperationDefinition(String name, @Nullable String methodName, Type inputType, Type outputType) {
        this.name = name;
        this.methodName = methodName;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getMethodName() {
        return this.methodName;
    }

    public Type getInputType() {
        return this.inputType;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.inputType, that.inputType) && Objects.equals(this.outputType, that.outputType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methodName, this.inputType, this.outputType);
    }

    public String toString() {
        return "OperationDefinition{name='" + this.name + '\'' + ", methodName='" + this.methodName + '\'' + ", inputType=" + this.inputType + ", outputType=" + this.outputType + '}';
    }

    public static class Builder {
        private @Nullable String name;
        private @Nullable String methodName;
        private @Nullable Type inputType;
        private @Nullable Type outputType;

        private Builder() {
        }

        private Builder(OperationDefinition definition) {
            this.name = definition.name;
            this.methodName = definition.methodName;
            this.inputType = definition.inputType;
            this.outputType = definition.outputType;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder setInputType(Type inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder setOutputType(Type outputType) {
            this.outputType = outputType;
            return this;
        }

        public OperationDefinition build() {
            Objects.requireNonNull(this.name, "Name required");
            Objects.requireNonNull(this.inputType, "Input type required");
            Objects.requireNonNull(this.outputType, "Output type required");
            return new OperationDefinition(this.name, this.methodName, this.inputType, this.outputType);
        }
    }
}

