/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix.tests;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public abstract class DetectPeerCloseWithoutReadTest {
    protected abstract EventLoopGroup newGroup();

    protected abstract Class<? extends ServerChannel> serverChannel();

    protected abstract Class<? extends Channel> clientChannel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void clientCloseWithoutServerReadIsDetected() throws InterruptedException {
        EventLoopGroup serverGroup = null;
        EventLoopGroup clientGroup = null;
        Channel serverChannel = null;
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicInteger bytesRead = new AtomicInteger();
            int expectedBytes = 100;
            serverGroup = this.newGroup();
            clientGroup = this.newGroup();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(serverGroup);
            sb.channel(this.serverChannel());
            sb.childOption(ChannelOption.AUTO_READ, (Object)false);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new TestHandler(bytesRead, latch)});
                }
            });
            serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Bootstrap cb = new Bootstrap();
            cb.group(serverGroup);
            cb.channel(this.clientChannel());
            cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            Channel clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            ByteBuf buf = clientChannel.alloc().buffer(100);
            buf.writerIndex(buf.writerIndex() + 100);
            clientChannel.writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            latch.await();
            Assert.assertEquals((long)100L, (long)bytesRead.get());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            if (serverGroup != null) {
                serverGroup.shutdownGracefully();
            }
            if (clientGroup != null) {
                clientGroup.shutdownGracefully();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void serverCloseWithoutClientReadIsDetected() throws InterruptedException {
        EventLoopGroup serverGroup = null;
        EventLoopGroup clientGroup = null;
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicInteger bytesRead = new AtomicInteger();
            int expectedBytes = 100;
            serverGroup = this.newGroup();
            clientGroup = this.newGroup();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(serverGroup);
            sb.channel(this.serverChannel());
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            ByteBuf buf = ctx.alloc().buffer(100);
                            buf.writerIndex(buf.writerIndex() + 100);
                            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            ctx.fireChannelActive();
                        }
                    }});
                }
            });
            serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Bootstrap cb = new Bootstrap();
            cb.group(serverGroup);
            cb.channel(this.clientChannel());
            cb.option(ChannelOption.AUTO_READ, (Object)false);
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new TestHandler(bytesRead, latch)});
                }
            });
            clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            latch.await();
            Assert.assertEquals((long)100L, (long)bytesRead.get());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
            if (serverGroup != null) {
                serverGroup.shutdownGracefully();
            }
            if (clientGroup != null) {
                clientGroup.shutdownGracefully();
            }
        }
    }

    private static final class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final AtomicInteger bytesRead;
        private final CountDownLatch latch;

        TestHandler(AtomicInteger bytesRead, CountDownLatch latch) {
            this.bytesRead = bytesRead;
            this.latch = latch;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.bytesRead.addAndGet(msg.readableBytes());
            ctx.read();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.latch.countDown();
            ctx.fireChannelInactive();
        }
    }
}

