/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import io.netty.util.internal.ObjectUtil;
import java.util.Objects;

public final class IoUringFixedBufferRingAllocator
implements IoUringBufferRingAllocator {
    private final ByteBufAllocator allocator;
    private final int bufferSize;

    public IoUringFixedBufferRingAllocator(ByteBufAllocator allocator, int bufferSize) {
        this.allocator = Objects.requireNonNull(allocator, "allocator");
        this.bufferSize = ObjectUtil.checkPositive((int)bufferSize, (String)"bufferSize");
    }

    public IoUringFixedBufferRingAllocator(int bufferSize) {
        this(ByteBufAllocator.DEFAULT, bufferSize);
    }

    @Override
    public ByteBuf allocate() {
        return this.allocator.directBuffer(this.bufferSize);
    }

    @Override
    public void lastBytesRead(int attempted, int actual) {
    }
}

