/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.channel.Channel;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.testsuite.transport.AbstractSingleThreadEventLoopTest;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class DefaultEventLoopTest
extends AbstractSingleThreadEventLoopTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIteratorNotSupported() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            Channel ch = this.newChannel();
            loop.register(ch).syncUninterruptibly();
            Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    loop.registeredChannelsIterator();
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Override
    protected EventLoopGroup newEventLoopGroup() {
        return new DefaultEventLoopGroup();
    }

    @Override
    protected Channel newChannel() {
        return new LocalChannel();
    }

    @Override
    protected Class<? extends ServerChannel> serverChannelClass() {
        return LocalServerChannel.class;
    }
}

