/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.stomp.websocket.StompSubscription;
import io.netty.example.stomp.websocket.StompVersion;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ChannelHandler.Sharable
public class StompChatHandler
extends SimpleChannelInboundHandler<StompFrame> {
    private final ConcurrentMap<String, Set<StompSubscription>> chatDestinations = new ConcurrentHashMap<String, Set<StompSubscription>>();

    protected void channelRead0(ChannelHandlerContext ctx, StompFrame inboundFrame) throws Exception {
        DecoderResult decoderResult = inboundFrame.decoderResult();
        if (decoderResult.isFailure()) {
            StompChatHandler.sendErrorFrame("rejected frame", decoderResult.toString(), ctx);
            return;
        }
        switch (inboundFrame.command()) {
            case STOMP: 
            case CONNECT: {
                StompChatHandler.onConnect(ctx, inboundFrame);
                break;
            }
            case SUBSCRIBE: {
                this.onSubscribe(ctx, inboundFrame);
                break;
            }
            case SEND: {
                this.onSend(ctx, inboundFrame);
                break;
            }
            case UNSUBSCRIBE: {
                this.onUnsubscribe(ctx, inboundFrame);
                break;
            }
            case DISCONNECT: {
                StompChatHandler.onDisconnect(ctx, inboundFrame);
                break;
            }
            default: {
                StompChatHandler.sendErrorFrame("unsupported command", "Received unsupported command " + inboundFrame.command(), ctx);
            }
        }
    }

    private void onSubscribe(ChannelHandlerContext ctx, StompFrame inboundFrame) {
        StompSubscription subscription;
        Set previousSubscriptions;
        String destination = inboundFrame.headers().getAsString((CharSequence)StompHeaders.DESTINATION);
        String subscriptionId = inboundFrame.headers().getAsString((CharSequence)StompHeaders.ID);
        if (destination == null || subscriptionId == null) {
            StompChatHandler.sendErrorFrame("missed header", "Required 'destination' or 'id' header missed", ctx);
            return;
        }
        Set<StompSubscription> subscriptions = (HashSet<StompSubscription>)this.chatDestinations.get(destination);
        if (subscriptions == null && (previousSubscriptions = (Set)this.chatDestinations.putIfAbsent(destination, subscriptions = new HashSet<StompSubscription>())) != null) {
            subscriptions = previousSubscriptions;
        }
        if (subscriptions.contains(subscription = new StompSubscription(subscriptionId, destination, ctx.channel()))) {
            StompChatHandler.sendErrorFrame("duplicate subscription", "Received duplicate subscription id=" + subscriptionId, ctx);
            return;
        }
        subscriptions.add(subscription);
        ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ((Set)StompChatHandler.this.chatDestinations.get(subscription.destination())).remove(subscription);
            }
        });
        String receiptId = inboundFrame.headers().getAsString((CharSequence)StompHeaders.RECEIPT);
        if (receiptId != null) {
            DefaultStompFrame receiptFrame = new DefaultStompFrame(StompCommand.RECEIPT);
            receiptFrame.headers().set((Object)StompHeaders.RECEIPT_ID, (Object)receiptId);
            ctx.writeAndFlush((Object)receiptFrame);
        }
    }

    private void onSend(ChannelHandlerContext ctx, StompFrame inboundFrame) {
        String destination = inboundFrame.headers().getAsString((CharSequence)StompHeaders.DESTINATION);
        if (destination == null) {
            StompChatHandler.sendErrorFrame("missed header", "required 'destination' header missed", ctx);
            return;
        }
        Set subscriptions = (Set)this.chatDestinations.get(destination);
        for (StompSubscription subscription : subscriptions) {
            subscription.channel().writeAndFlush((Object)StompChatHandler.transformToMessage(inboundFrame, subscription));
        }
    }

    private void onUnsubscribe(ChannelHandlerContext ctx, StompFrame inboundFrame) {
        String subscriptionId = inboundFrame.headers().getAsString((CharSequence)StompHeaders.SUBSCRIPTION);
        for (Map.Entry entry : this.chatDestinations.entrySet()) {
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                StompSubscription subscription = (StompSubscription)iterator.next();
                if (!subscription.id().equals(subscriptionId) || !subscription.channel().equals(ctx.channel())) continue;
                iterator.remove();
                return;
            }
        }
    }

    private static void onConnect(ChannelHandlerContext ctx, StompFrame inboundFrame) {
        String acceptVersions = inboundFrame.headers().getAsString((CharSequence)StompHeaders.ACCEPT_VERSION);
        StompVersion handshakeAcceptVersion = (StompVersion)((Object)ctx.channel().attr(StompVersion.CHANNEL_ATTRIBUTE_KEY).get());
        if (acceptVersions == null || !acceptVersions.contains(handshakeAcceptVersion.version())) {
            StompChatHandler.sendErrorFrame("invalid version", "Received invalid version, expected " + handshakeAcceptVersion.version(), ctx);
            return;
        }
        DefaultStompFrame connectedFrame = new DefaultStompFrame(StompCommand.CONNECTED);
        ((StompHeaders)((StompHeaders)connectedFrame.headers().set((Object)StompHeaders.VERSION, (Object)handshakeAcceptVersion.version())).set((Object)StompHeaders.SERVER, (Object)"Netty-Server")).set((Object)StompHeaders.HEART_BEAT, (Object)"0,0");
        ctx.writeAndFlush((Object)connectedFrame);
    }

    private static void onDisconnect(ChannelHandlerContext ctx, StompFrame inboundFrame) {
        String receiptId = inboundFrame.headers().getAsString((CharSequence)StompHeaders.RECEIPT);
        if (receiptId == null) {
            ctx.close();
            return;
        }
        DefaultStompFrame receiptFrame = new DefaultStompFrame(StompCommand.RECEIPT);
        receiptFrame.headers().set((Object)StompHeaders.RECEIPT_ID, (Object)receiptId);
        ctx.writeAndFlush((Object)receiptFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendErrorFrame(String message, String description, ChannelHandlerContext ctx) {
        DefaultStompFrame errorFrame = new DefaultStompFrame(StompCommand.ERROR);
        errorFrame.headers().set((Object)StompHeaders.MESSAGE, (Object)message);
        if (description != null) {
            errorFrame.content().writeCharSequence((CharSequence)description, CharsetUtil.UTF_8);
        }
        ctx.writeAndFlush((Object)errorFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static StompFrame transformToMessage(StompFrame sendFrame, StompSubscription subscription) {
        DefaultStompFrame messageFrame = new DefaultStompFrame(StompCommand.MESSAGE, sendFrame.content().retainedDuplicate());
        String id = UUID.randomUUID().toString();
        ((StompHeaders)((StompHeaders)messageFrame.headers().set((Object)StompHeaders.MESSAGE_ID, (Object)id)).set((Object)StompHeaders.SUBSCRIPTION, (Object)subscription.id())).set((Object)StompHeaders.CONTENT_LENGTH, (Object)Integer.toString(messageFrame.content().readableBytes()));
        CharSequence contentType = (CharSequence)sendFrame.headers().get((Object)StompHeaders.CONTENT_TYPE);
        if (contentType != null) {
            messageFrame.headers().set((Object)StompHeaders.CONTENT_TYPE, (Object)contentType);
        }
        return messageFrame;
    }
}

