/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.file;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataChunkedInput;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;

public class Http2StaticFileServerHandler
extends ChannelDuplexHandler {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private Http2FrameStream stream;
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[^-\\._]?[^<>&\\\"]*");

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            RandomAccessFile raf;
            long fileLastModifiedSeconds;
            SimpleDateFormat dateFormatter;
            Date ifModifiedSinceDate;
            long ifModifiedSinceDateSeconds;
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            this.stream = headersFrame.stream();
            if (!HttpMethod.GET.toString().equals(headersFrame.headers().method().toString())) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            String uri = headersFrame.headers().path().toString();
            String path = Http2StaticFileServerHandler.sanitizeUri(uri);
            if (path == null) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            File file = new File(path);
            if (file.isHidden() || !file.exists()) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            if (file.isDirectory()) {
                if (uri.endsWith("/")) {
                    this.sendListing(ctx, file, uri);
                } else {
                    this.sendRedirect(ctx, uri + '/');
                }
                return;
            }
            if (!file.isFile()) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            CharSequence ifModifiedSince = (CharSequence)headersFrame.headers().get((Object)HttpHeaderNames.IF_MODIFIED_SINCE);
            if (ifModifiedSince != null && !ifModifiedSince.toString().isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince.toString())).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
                this.sendNotModified(ctx);
                return;
            }
            try {
                raf = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException ignore) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            long fileLength = raf.length();
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.status((CharSequence)"200");
            headers.setLong((Object)HttpHeaderNames.CONTENT_LENGTH, fileLength);
            Http2StaticFileServerHandler.setContentTypeHeader((Http2Headers)headers, file);
            Http2StaticFileServerHandler.setDateAndCacheHeaders((Http2Headers)headers, file);
            ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers).stream(this.stream));
            ChannelFuture sendFileFuture = ctx.writeAndFlush((Object)new Http2DataChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192), this.stream), (ChannelPromise)ctx.newProgressivePromise());
            sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                    if (total < 0L) {
                        System.err.println(future.channel() + " Transfer progress: " + progress);
                    } else {
                        System.err.println(future.channel() + " Transfer progress: " + progress + " / " + total);
                    }
                }

                public void operationComplete(ChannelProgressiveFuture future) {
                    System.err.println(future.channel() + " Transfer complete.");
                }
            });
        } else {
            System.out.println("Unsupported message type: " + msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static String sanitizeUri(String uri) throws UnsupportedEncodingException {
        if ((uri = URLDecoder.decode(uri, "UTF-8")).isEmpty() || uri.charAt(0) != '/') {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return SystemPropertyUtil.get((String)"user.dir") + File.separator + uri;
    }

    private void sendListing(ChannelHandlerContext ctx, File dir, String dirPath) {
        StringBuilder buf = new StringBuilder().append("<!DOCTYPE html>\r\n").append("<html><head><meta charset='utf-8' /><title>").append("Listing of: ").append(dirPath).append("</title></head><body>\r\n").append("<h3>Listing of: ").append(dirPath).append("</h3>\r\n").append("<ul>").append("<li><a href=\"../\">..</a></li>\r\n");
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                String name;
                if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
                buf.append("<li><a href=\"").append(name).append("\">").append(name).append("</a></li>\r\n");
            }
        }
        buf.append("</ul></body></html>\r\n");
        ByteBuf buffer = ctx.alloc().buffer(buf.length());
        buffer.writeCharSequence((CharSequence)buf.toString(), CharsetUtil.UTF_8);
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)HttpResponseStatus.OK.toString());
        headers.add((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        ctx.write((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers).stream(this.stream));
        ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(buffer, true).stream(this.stream));
    }

    private void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)HttpResponseStatus.FOUND.toString());
        headers.add((Object)HttpHeaderNames.LOCATION, (Object)newUri);
        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers, true).stream(this.stream));
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)status.toString());
        headers.add((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)headers);
        headersFrame.stream(this.stream);
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8), true);
        dataFrame.stream(this.stream);
        ctx.write((Object)headersFrame);
        ctx.writeAndFlush((Object)dataFrame);
    }

    private void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)HttpResponseStatus.NOT_MODIFIED.toString());
        Http2StaticFileServerHandler.setDateHeader((Http2Headers)headers);
        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers, true).stream(this.stream));
    }

    private static void setDateHeader(Http2Headers headers) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        headers.set((Object)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
    }

    private static void setDateAndCacheHeaders(Http2Headers headers, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        headers.set((Object)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        headers.set((Object)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
        headers.set((Object)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=60");
        headers.set((Object)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(Http2Headers headers, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        headers.set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)mimeTypesMap.getContentType(file.getPath()));
    }
}

