/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class ConstantPool<T extends Constant<T>> {
    private final Map<String, T> constants = new HashMap<String, T>();
    private int nextId = 1;

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        if (firstNameComponent == null) {
            throw new NullPointerException("firstNameComponent");
        }
        if (secondNameComponent == null) {
            throw new NullPointerException("secondNameComponent");
        }
        return this.valueOf(firstNameComponent.getName() + '#' + secondNameComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        Map<String, T> map = this.constants;
        synchronized (map) {
            Constant c = (Constant)this.constants.get(name);
            if (c == null) {
                c = this.newConstant(this.nextId, name);
                this.constants.put(name, c);
                ++this.nextId;
            }
            return (T)c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        ObjectUtil.checkNotNull(name, "name");
        Map<String, T> map = this.constants;
        synchronized (map) {
            return this.constants.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T newInstance(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        Map<String, T> map = this.constants;
        synchronized (map) {
            Constant c = (Constant)this.constants.get(name);
            if (c == null) {
                c = this.newConstant(this.nextId, name);
                this.constants.put(name, c);
                ++this.nextId;
            } else {
                throw new IllegalArgumentException(String.format("'%s' is already in use", name));
            }
            return (T)c;
        }
    }

    protected abstract T newConstant(int var1, String var2);
}

