/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final Map<String, UpgradeCodec> upgradeCodecMap;
    private final SourceCodec sourceCodec;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, Collection<UpgradeCodec> upgradeCodecs, int maxContentLength) {
        super(maxContentLength);
        if (sourceCodec == null) {
            throw new NullPointerException("sourceCodec");
        }
        if (upgradeCodecs == null) {
            throw new NullPointerException("upgradeCodecs");
        }
        this.sourceCodec = sourceCodec;
        this.upgradeCodecMap = new LinkedHashMap<String, UpgradeCodec>(upgradeCodecs.size());
        for (UpgradeCodec upgradeCodec : upgradeCodecs) {
            String name = upgradeCodec.protocol().toUpperCase(Locale.US);
            this.upgradeCodecMap.put(name, upgradeCodec);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        FullHttpRequest fullRequest;
        this.handlingUpgrade |= HttpServerUpgradeHandler.isUpgradeRequest(msg);
        if (!this.handlingUpgrade) {
            ReferenceCountUtil.retain(msg);
            out.add(msg);
            return;
        }
        if (msg instanceof FullHttpRequest) {
            fullRequest = (FullHttpRequest)msg;
            ReferenceCountUtil.retain(msg);
            out.add(msg);
        } else {
            super.decode(ctx, msg, out);
            if (out.isEmpty()) {
                return;
            }
            assert (out.size() == 1);
            this.handlingUpgrade = false;
            fullRequest = (FullHttpRequest)out.get(0);
        }
        if (this.upgrade(ctx, fullRequest)) {
            out.clear();
        }
    }

    private static boolean isUpgradeRequest(HttpObject msg) {
        return msg instanceof HttpRequest && ((HttpRequest)msg).headers().get(HttpHeaderNames.UPGRADE) != null;
    }

    private boolean upgrade(final ChannelHandlerContext ctx, final FullHttpRequest request) {
        String upgradeHeader = request.headers().get(HttpHeaderNames.UPGRADE);
        final UpgradeCodec upgradeCodec = this.selectUpgradeCodec(upgradeHeader);
        if (upgradeCodec == null) {
            return false;
        }
        String connectionHeader = request.headers().get(HttpHeaderNames.CONNECTION);
        if (connectionHeader == null) {
            return false;
        }
        Collection<String> requiredHeaders = upgradeCodec.requiredUpgradeHeaders();
        Set<CharSequence> values = HttpServerUpgradeHandler.splitHeader(connectionHeader);
        if (!values.contains(HttpHeaderNames.UPGRADE) || !values.containsAll(requiredHeaders)) {
            return false;
        }
        for (String requiredHeader : requiredHeaders) {
            if (request.headers().contains(requiredHeader)) continue;
            return false;
        }
        final UpgradeEvent event = new UpgradeEvent(upgradeCodec.protocol(), request);
        final FullHttpResponse upgradeResponse = HttpServerUpgradeHandler.createUpgradeResponse(upgradeCodec);
        upgradeCodec.prepareUpgradeResponse(ctx, request, upgradeResponse);
        ctx.writeAndFlush(upgradeResponse).addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    if (future.isSuccess()) {
                        HttpServerUpgradeHandler.this.sourceCodec.upgradeFrom(ctx);
                        upgradeCodec.upgradeTo(ctx, request, upgradeResponse);
                        ctx.fireUserEventTriggered(event.retain());
                        ctx.pipeline().remove(HttpServerUpgradeHandler.this);
                    } else {
                        future.channel().close();
                    }
                }
                finally {
                    event.release();
                }
            }
        });
        return true;
    }

    private UpgradeCodec selectUpgradeCodec(CharSequence upgradeHeader) {
        Set<CharSequence> requestedProtocols = HttpServerUpgradeHandler.splitHeader(upgradeHeader);
        LinkedHashSet<String> supportedProtocols = new LinkedHashSet<String>(this.upgradeCodecMap.keySet());
        supportedProtocols.retainAll(requestedProtocols);
        if (!supportedProtocols.isEmpty()) {
            String protocol = ((String)supportedProtocols.iterator().next()).toUpperCase(Locale.US);
            return this.upgradeCodecMap.get(protocol);
        }
        return null;
    }

    private static FullHttpResponse createUpgradeResponse(UpgradeCodec upgradeCodec) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)upgradeCodec.protocol());
        res.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
        return res;
    }

    private static Set<CharSequence> splitHeader(CharSequence header) {
        StringBuilder builder = new StringBuilder(header.length());
        TreeSet<CharSequence> protocols = new TreeSet<CharSequence>(AsciiString.CHARSEQUENCE_CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                protocols.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            protocols.add(builder.toString());
        }
        return protocols;
    }

    public static final class UpgradeEvent
    implements ReferenceCounted {
        private final String protocol;
        private final FullHttpRequest upgradeRequest;

        private UpgradeEvent(String protocol, FullHttpRequest upgradeRequest) {
            this.protocol = protocol;
            this.upgradeRequest = upgradeRequest;
        }

        public String protocol() {
            return this.protocol;
        }

        public FullHttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        @Override
        public int refCnt() {
            return this.upgradeRequest.refCnt();
        }

        @Override
        public UpgradeEvent retain() {
            this.upgradeRequest.retain();
            return this;
        }

        @Override
        public UpgradeEvent retain(int increment) {
            this.upgradeRequest.retain(increment);
            return this;
        }

        @Override
        public UpgradeEvent touch() {
            this.upgradeRequest.touch();
            return this;
        }

        @Override
        public UpgradeEvent touch(Object hint) {
            this.upgradeRequest.touch(hint);
            return this;
        }

        @Override
        public boolean release() {
            return this.upgradeRequest.release();
        }

        @Override
        public boolean release(int decrement) {
            return this.upgradeRequest.release();
        }

        public String toString() {
            return "UpgradeEvent [protocol=" + this.protocol + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }

    public static interface UpgradeCodec {
        public String protocol();

        public Collection<String> requiredUpgradeHeaders();

        public void prepareUpgradeResponse(ChannelHandlerContext var1, FullHttpRequest var2, FullHttpResponse var3);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpRequest var2, FullHttpResponse var3);
    }

    public static interface SourceCodec {
        public void upgradeFrom(ChannelHandlerContext var1);
    }
}

