/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.ConvertibleHeaders;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultConvertibleHeaders<UnconvertedType, ConvertedType>
extends DefaultHeaders<UnconvertedType>
implements ConvertibleHeaders<UnconvertedType, ConvertedType> {
    private final ConvertibleHeaders.TypeConverter<UnconvertedType, ConvertedType> typeConverter;

    public DefaultConvertibleHeaders(Comparator<? super UnconvertedType> keyComparator, Comparator<? super UnconvertedType> valueComparator, DefaultHeaders.HashCodeGenerator<UnconvertedType> hashCodeGenerator, Headers.ValueConverter<UnconvertedType> valueConverter, ConvertibleHeaders.TypeConverter<UnconvertedType, ConvertedType> typeConverter) {
        super(keyComparator, valueComparator, hashCodeGenerator, valueConverter);
        this.typeConverter = typeConverter;
    }

    public DefaultConvertibleHeaders(Comparator<? super UnconvertedType> keyComparator, Comparator<? super UnconvertedType> valueComparator, DefaultHeaders.HashCodeGenerator<UnconvertedType> hashCodeGenerator, Headers.ValueConverter<UnconvertedType> valueConverter, ConvertibleHeaders.TypeConverter<UnconvertedType, ConvertedType> typeConverter, DefaultHeaders.NameConverter<UnconvertedType> nameConverter) {
        super(keyComparator, valueComparator, hashCodeGenerator, valueConverter, nameConverter);
        this.typeConverter = typeConverter;
    }

    @Override
    public ConvertedType getAndConvert(UnconvertedType name) {
        return this.getAndConvert(name, null);
    }

    @Override
    public ConvertedType getAndConvert(UnconvertedType name, ConvertedType defaultValue) {
        UnconvertedType v = this.get(name);
        if (v == null) {
            return defaultValue;
        }
        return this.typeConverter.toConvertedType(v);
    }

    @Override
    public ConvertedType getAndRemoveAndConvert(UnconvertedType name) {
        return this.getAndRemoveAndConvert(name, null);
    }

    @Override
    public ConvertedType getAndRemoveAndConvert(UnconvertedType name, ConvertedType defaultValue) {
        UnconvertedType v = this.getAndRemove(name);
        if (v == null) {
            return defaultValue;
        }
        return this.typeConverter.toConvertedType(v);
    }

    @Override
    public List<ConvertedType> getAllAndConvert(UnconvertedType name) {
        List<UnconvertedType> all = this.getAll(name);
        ArrayList<ConvertedType> allConverted = new ArrayList<ConvertedType>(all.size());
        for (int i = 0; i < all.size(); ++i) {
            allConverted.add(this.typeConverter.toConvertedType(all.get(i)));
        }
        return allConverted;
    }

    @Override
    public List<ConvertedType> getAllAndRemoveAndConvert(UnconvertedType name) {
        List<UnconvertedType> all = this.getAllAndRemove(name);
        ArrayList<ConvertedType> allConverted = new ArrayList<ConvertedType>(all.size());
        for (int i = 0; i < all.size(); ++i) {
            allConverted.add(this.typeConverter.toConvertedType(all.get(i)));
        }
        return allConverted;
    }

    @Override
    public List<Map.Entry<ConvertedType, ConvertedType>> entriesConverted() {
        List entries = this.entries();
        ArrayList<Map.Entry<ConvertedType, ConvertedType>> entriesConverted = new ArrayList<Map.Entry<ConvertedType, ConvertedType>>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            entriesConverted.add(new ConvertedEntry(entries.get(i)));
        }
        return entriesConverted;
    }

    @Override
    public Iterator<Map.Entry<ConvertedType, ConvertedType>> iteratorConverted() {
        return new ConvertedIterator();
    }

    @Override
    public Set<ConvertedType> namesAndConvert(Comparator<ConvertedType> comparator) {
        Set names = this.names();
        TreeSet<ConvertedType> namesConverted = new TreeSet<ConvertedType>(comparator);
        for (Object unconverted : names) {
            namesConverted.add(this.typeConverter.toConvertedType(unconverted));
        }
        return namesConverted;
    }

    private final class ConvertedEntry
    implements Map.Entry<ConvertedType, ConvertedType> {
        private final Map.Entry<UnconvertedType, UnconvertedType> entry;
        private ConvertedType name;
        private ConvertedType value;

        ConvertedEntry(Map.Entry<UnconvertedType, UnconvertedType> entry) {
            this.entry = entry;
        }

        @Override
        public ConvertedType getKey() {
            if (this.name == null) {
                this.name = DefaultConvertibleHeaders.this.typeConverter.toConvertedType(this.entry.getKey());
            }
            return this.name;
        }

        @Override
        public ConvertedType getValue() {
            if (this.value == null) {
                this.value = DefaultConvertibleHeaders.this.typeConverter.toConvertedType(this.entry.getValue());
            }
            return this.value;
        }

        @Override
        public ConvertedType setValue(ConvertedType value) {
            Object old = this.getValue();
            this.entry.setValue(DefaultConvertibleHeaders.this.typeConverter.toUnconvertedType(value));
            return old;
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    private final class ConvertedIterator
    implements Iterator<Map.Entry<ConvertedType, ConvertedType>> {
        private final Iterator<Map.Entry<UnconvertedType, UnconvertedType>> iter;

        private ConvertedIterator() {
            this.iter = DefaultConvertibleHeaders.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<ConvertedType, ConvertedType> next() {
            Map.Entry next = this.iter.next();
            return new ConvertedEntry(next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

