/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.quic.Quic;
import io.netty.incubator.codec.quic.QuicPacketType;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

public final class QuicHeaderParser
implements AutoCloseable {
    private final int maxTokenLength;
    private final int localConnectionIdLength;
    private final ByteBuf versionBuffer;
    private final ByteBuf typeBuffer;
    private final ByteBuf scidLenBuffer;
    private final ByteBuf scidBuffer;
    private final ByteBuf dcidLenBuffer;
    private final ByteBuf dcidBuffer;
    private final ByteBuf tokenBuffer;
    private final ByteBuf tokenLenBuffer;
    private boolean closed;

    public QuicHeaderParser(int maxTokenLength, int localConnectionIdLength) {
        Quic.ensureAvailability();
        this.maxTokenLength = ObjectUtil.checkPositiveOrZero((int)maxTokenLength, (String)"maxTokenLength");
        this.localConnectionIdLength = ObjectUtil.checkPositiveOrZero((int)localConnectionIdLength, (String)"localConnectionIdLength");
        this.versionBuffer = Quiche.allocateNativeOrder(4);
        this.typeBuffer = Quiche.allocateNativeOrder(1);
        this.scidLenBuffer = Quiche.allocateNativeOrder(4);
        this.dcidLenBuffer = Quiche.allocateNativeOrder(4);
        this.tokenLenBuffer = Quiche.allocateNativeOrder(4);
        this.scidBuffer = Unpooled.directBuffer((int)Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.dcidBuffer = Unpooled.directBuffer((int)Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.tokenBuffer = Unpooled.directBuffer((int)maxTokenLength);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.versionBuffer.release();
            this.typeBuffer.release();
            this.scidBuffer.release();
            this.scidLenBuffer.release();
            this.dcidBuffer.release();
            this.dcidLenBuffer.release();
            this.tokenLenBuffer.release();
            this.tokenBuffer.release();
        }
    }

    public void parse(InetSocketAddress sender, InetSocketAddress recipient, ByteBuf packet, QuicHeaderProcessor callback) throws Exception {
        if (this.closed) {
            throw new IllegalStateException(QuicHeaderParser.class.getSimpleName() + " is already closed");
        }
        this.scidLenBuffer.setInt(0, Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.dcidLenBuffer.setInt(0, Quiche.QUICHE_MAX_CONN_ID_LEN);
        this.tokenLenBuffer.setInt(0, this.maxTokenLength);
        int res = Quiche.quiche_header_info(Quiche.readerMemoryAddress(packet), packet.readableBytes(), this.localConnectionIdLength, Quiche.memoryAddress(this.versionBuffer, 0, this.versionBuffer.capacity()), Quiche.memoryAddress(this.typeBuffer, 0, this.typeBuffer.capacity()), Quiche.memoryAddress(this.scidBuffer, 0, this.scidBuffer.capacity()), Quiche.memoryAddress(this.scidLenBuffer, 0, this.scidLenBuffer.capacity()), Quiche.memoryAddress(this.dcidBuffer, 0, this.dcidBuffer.capacity()), Quiche.memoryAddress(this.dcidLenBuffer, 0, this.dcidLenBuffer.capacity()), Quiche.memoryAddress(this.tokenBuffer, 0, this.tokenBuffer.capacity()), Quiche.writerMemoryAddress(this.tokenLenBuffer));
        if (res < 0) {
            throw Quiche.newException(res);
        }
        int version = this.versionBuffer.getInt(0);
        byte type = this.typeBuffer.getByte(0);
        int scidLen = this.scidLenBuffer.getInt(0);
        int dcidLen = this.dcidLenBuffer.getInt(0);
        int tokenLen = this.tokenLenBuffer.getInt(0);
        callback.process(sender, recipient, packet, QuicPacketType.of(type), version, this.scidBuffer.setIndex(0, scidLen), this.dcidBuffer.setIndex(0, dcidLen), this.tokenBuffer.setIndex(0, tokenLen));
    }

    public static interface QuicHeaderProcessor {
        public void process(InetSocketAddress var1, InetSocketAddress var2, ByteBuf var3, QuicPacketType var4, int var5, ByteBuf var6, ByteBuf var7, ByteBuf var8) throws Exception;
    }
}

