/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.weka.internal;

import io.nessus.weka.AssertArg;
import io.nessus.weka.AssertState;
import io.nessus.weka.Dataset;
import io.nessus.weka.FunctionalClassifier;
import io.nessus.weka.FunctionalEvaluation;
import io.nessus.weka.FunctionalInstances;
import io.nessus.weka.UncheckedException;
import io.nessus.weka.utils.DatasetUtils;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instances;

public class DatasetImpl
extends Dataset
implements FunctionalEvaluation<Dataset>,
FunctionalClassifier<Dataset>,
FunctionalInstances<Dataset> {
    private static final String DEFAULT_SLOT = "_default";
    private static final String TRAINING_DATA_SLOT = "_training";
    private static final String TEST_DATA_SLOT = "_test";
    private final Map<String, Instances> storage = new HashMap<String, Instances>();
    private Classifier classifier;
    private Evaluation evaluation;
    private Instances instances;

    public DatasetImpl(Instances instances) {
        this.instances = this.asignClassIndex(instances);
    }

    private Instances asignClassIndex(Instances instances) {
        AssertArg.notNull(instances, "Null instances");
        if (instances.classIndex() < 0) {
            Attribute attr = instances.attribute("class");
            if (attr != null) {
                instances.setClass(attr);
            } else {
                int numatts = instances.numAttributes();
                attr = instances.attribute(numatts - 1);
                if (attr.isNominal()) {
                    instances.setClass(attr);
                }
            }
        }
        return instances;
    }

    @Override
    public Dataset read(Path inpath) {
        Instances result = DatasetUtils.read(inpath);
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset read(String inpath) {
        Instances result = DatasetUtils.read(Paths.get(inpath, new String[0]));
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset read(URL url) {
        Instances result = DatasetUtils.read(url);
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset write(Path outpath) {
        DatasetUtils.write(this.instances, outpath);
        return this;
    }

    @Override
    public Dataset write(String outpath) {
        DatasetUtils.write(this.instances, Paths.get(outpath, new String[0]));
        return this;
    }

    @Override
    public Dataset push() {
        this.push(DEFAULT_SLOT);
        return this;
    }

    @Override
    public Dataset pushTrainingSet() {
        this.push(TRAINING_DATA_SLOT);
        return this;
    }

    @Override
    public Dataset pushTestSet() {
        this.push(TEST_DATA_SLOT);
        return this;
    }

    @Override
    public Dataset push(String name) {
        this.storage.put(name, new Instances(this.instances));
        return this;
    }

    @Override
    public Dataset pop() {
        this.pop(DEFAULT_SLOT);
        return this;
    }

    @Override
    public Dataset popTrainingSet() {
        this.pop(TRAINING_DATA_SLOT);
        return this;
    }

    @Override
    public Dataset popTestSet() {
        this.pop(TEST_DATA_SLOT);
        return this;
    }

    @Override
    public Dataset pop(String name) {
        Instances result = this.storage.remove(name);
        AssertState.notNull(result, "Cannot find instances with name '" + name + "' on stack");
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset apply(String filterSpec) {
        Instances result = DatasetUtils.applyFilter(this.getInstances(), filterSpec);
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset applyToInstances(UnaryOperator<Instances> operator) {
        Instances result = (Instances)operator.apply(this.instances);
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset applyToInstances(Function<Dataset, Instances> function) {
        Instances result = function.apply(this);
        this.instances = this.asignClassIndex(result);
        return this;
    }

    @Override
    public Dataset consumeInstances(Consumer<Instances> consumer) {
        consumer.accept(this.instances);
        return this;
    }

    @Override
    public List<Attribute> getAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        Enumeration en = this.instances.enumerateAttributes();
        while (en.hasMoreElements()) {
            result.add((Attribute)en.nextElement());
        }
        return result;
    }

    @Override
    public Instances getInstances() {
        return this.instances;
    }

    @Override
    public Dataset applyToClassifier(Function<Dataset, Classifier> function) {
        Classifier result = function.apply(this);
        AssertState.notNull(result, "Null classifier");
        this.classifier = result;
        return this;
    }

    @Override
    public Dataset applyToClassifier(UnaryOperator<Classifier> operator) {
        Classifier result = (Classifier)operator.apply(this.assertClassifier());
        AssertState.notNull(result, "Null classifier");
        this.classifier = result;
        return this;
    }

    @Override
    public Dataset consumeClassifier(Consumer<Classifier> consumer) {
        consumer.accept(this.assertClassifier());
        return this;
    }

    @Override
    public Dataset buildClassifier(String classifierSpec) {
        Classifier result = DatasetUtils.buildClassifier(this.getInstances(), classifierSpec);
        AssertState.notNull(result, "Null classifier");
        this.classifier = result;
        return this;
    }

    @Override
    public Dataset loadClassifier(Supplier<Classifier> supplier) {
        Classifier result = supplier.get();
        AssertState.notNull(result, "Null classifier");
        this.classifier = result;
        return this;
    }

    @Override
    public Classifier getClassifier() {
        return this.classifier;
    }

    @Override
    public Dataset applyToEvaluation(Function<Dataset, Evaluation> function) {
        Evaluation result = function.apply(this);
        AssertState.notNull(result, "Null evaluation");
        this.evaluation = result;
        return this;
    }

    @Override
    public Dataset applyToEvaluation(UnaryOperator<Evaluation> operator) {
        Evaluation result = (Evaluation)operator.apply(this.assertEvaluation());
        AssertState.notNull(result, "Null evaluation");
        this.evaluation = result;
        return this;
    }

    @Override
    public Dataset consumeEvaluation(Consumer<Evaluation> consumer) {
        consumer.accept(this.assertEvaluation());
        return this;
    }

    @Override
    public Dataset crossValidateModel(int numFolds, int seed) {
        Instances data = this.getInstances();
        try {
            Evaluation ev = this.evaluate().getEvaluation();
            ev.crossValidateModel(this.assertClassifier(), data, numFolds, new Random(seed));
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
        return this;
    }

    @Override
    public Dataset evaluateModel(Dataset dataset) {
        try {
            Evaluation ev = this.evaluate().getEvaluation();
            Instances testing = dataset.getInstances();
            ev.evaluateModel(this.assertClassifier(), testing, new Object[0]);
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
        return this;
    }

    @Override
    public Dataset evaluateModel() {
        try {
            Evaluation ev = this.evaluate().getEvaluation();
            ev.evaluateModel(this.assertClassifier(), this.instances, new Object[0]);
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
        return this;
    }

    @Override
    public Dataset evaluate() {
        try {
            this.evaluation = new Evaluation(this.instances);
        }
        catch (Exception ex) {
            throw UncheckedException.create(ex);
        }
        return this;
    }

    @Override
    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    @Override
    public Dataset consumeDataset(Consumer<Dataset> consumer) {
        consumer.accept(this);
        return this;
    }

    private Classifier assertClassifier() {
        AssertState.notNull(this.classifier, "Classifier not available");
        return this.classifier;
    }

    private Evaluation assertEvaluation() {
        AssertState.notNull(this.evaluation, "Evaluation not available");
        return this.evaluation;
    }
}

