/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.weka;

import io.nessus.weka.UncheckedException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import weka.classifiers.Classifier;

public class ModelPersister
implements Consumer<Classifier> {
    private final Path outpath;

    public ModelPersister(String outpath) {
        this(Paths.get(outpath, new String[0]));
    }

    public ModelPersister(Path outpath) {
        this.outpath = outpath;
    }

    @Override
    public void accept(Classifier cl) {
        try (FileOutputStream outstream = new FileOutputStream(this.outpath.toFile());){
            this.outpath.getParent().toFile().mkdirs();
            new ObjectOutputStream(outstream).writeObject(cl);
        }
        catch (IOException ex) {
            throw UncheckedException.create(ex);
        }
    }
}

