/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.rest;

import io.nessus.common.Config;
import io.nessus.common.ConfigSupport;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractIdentityManager<T extends Config>
extends ConfigSupport<T>
implements IdentityManager {
    public AbstractIdentityManager(T config) {
        super(config);
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        BasicAccount account = new BasicAccount(id);
        boolean access = this.verify(account, credential);
        return access ? account : null;
    }

    public abstract boolean verify(Account var1, Credential var2);

    public Account verify(Credential credential) {
        return null;
    }

    public static class BasicAccount
    implements Account {
        private final String id;

        public BasicAccount(String id) {
            this.id = id;
        }

        public Principal getPrincipal() {
            return new BasicPricipal(this.id);
        }

        public Set<String> getRoles() {
            return Collections.emptySet();
        }

        public String toString() {
            return String.format("BasicAccount[id=%s, roles=%s]", this.id, this.getRoles());
        }
    }

    public static class BasicPricipal
    implements Principal {
        private final String id;

        public BasicPricipal(String id) {
            this.id = id;
        }

        @Override
        public String getName() {
            return this.id;
        }
    }
}

