/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.rest;

import io.nessus.common.Config;
import io.undertow.Undertow;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxrsServer
extends UndertowJaxrsServer {
    static final Logger LOG = LoggerFactory.getLogger(JaxrsServer.class);
    private String hostname;
    private Integer httpPort;
    private Integer httpsPort;
    private SSLContext sslContext;
    private HandlerWrapper securityWrapper;

    public JaxrsServer(Config config) {
    }

    public JaxrsServer withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public JaxrsServer withHttpPort(int port) {
        this.httpPort = port;
        return this;
    }

    public JaxrsServer withHttpsPort(int port, SSLContext sslContext) {
        this.sslContext = sslContext;
        this.httpsPort = port;
        return this;
    }

    public JaxrsServer withRootSecurity(HandlerWrapper wrapper) {
        this.securityWrapper = wrapper;
        return this;
    }

    public JaxrsServer start() {
        Undertow.Builder builder = Undertow.builder();
        PathHandler handler = this.root;
        if (this.securityWrapper != null) {
            handler = this.securityWrapper.wrap((HttpHandler)handler);
        }
        builder.setHandler((HttpHandler)handler);
        if (this.httpPort != null) {
            builder.addHttpListener(this.httpPort.intValue(), this.hostname);
        }
        if (this.httpsPort != null) {
            builder.addHttpsListener(this.httpsPort.intValue(), this.hostname, this.sslContext);
        }
        LOG.info("Starting {}", (Object)this);
        this.server = builder.build();
        this.server.start();
        return this;
    }

    public JaxrsServer setHostname(String hostname) {
        return this.withHostname(hostname);
    }

    public JaxrsServer setPort(int port) {
        return this.withHttpPort(port);
    }

    public JaxrsServer deploy(Application application) {
        return this.deploy("/", application);
    }

    public JaxrsServer deploy(String contextPath, Application application) {
        super.deploy(application, contextPath);
        return this;
    }

    public JaxrsServer deploy(DeploymentInfo di) {
        if (di.getInitialSecurityWrapper() == null) {
            di.setInitialSecurityWrapper(this.securityWrapper);
        }
        super.deploy(di);
        return this;
    }

    public JaxrsServer addPrefixPath(String path, HttpHandler handler) {
        this.root.addPrefixPath(path, handler);
        return this;
    }

    public String toString() {
        return String.format("JaxrsServer[host=%s, http=%d, https=%d, ssl=%s]", this.hostname, this.httpPort, this.httpsPort, this.sslContext);
    }

    static class SecurityContextAssociationHandler
    extends SecurityInitialHandler {
        SecurityContextAssociationHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, HttpHandler next) {
            super(authenticationMode, identityManager, next);
        }

        public SecurityContext createSecurityContext(HttpServerExchange exchange) {
            SecurityContext context = exchange.getSecurityContext();
            if (context != null && context.isAuthenticated()) {
                return context;
            }
            return super.createSecurityContext(exchange);
        }
    }

    public static class BasicSecurityWrapper
    implements HandlerWrapper {
        private final IdentityManager identityManager;
        private final boolean required;

        public BasicSecurityWrapper(IdentityManager identityManager, boolean required) {
            this.identityManager = identityManager;
            this.required = required;
        }

        public HttpHandler wrap(HttpHandler rootHandler) {
            Object handler = rootHandler;
            handler = new AuthenticationCallHandler(handler);
            if (this.required) {
                handler = new AuthenticationConstraintHandler(handler);
            }
            handler = new AuthenticationMechanismsHandler(handler, Arrays.asList(new BasicAuthenticationMechanism("MyRealm")));
            handler = new SecurityContextAssociationHandler(AuthenticationMode.PRO_ACTIVE, this.identityManager, (HttpHandler)handler);
            return handler;
        }
    }
}

