/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.rest;

import io.nessus.common.Config;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxrsServer
extends UndertowJaxrsServer {
    static final Logger LOG = LoggerFactory.getLogger(JaxrsServer.class);
    private String hostname;
    private Integer httpPort;
    private Integer httpsPort;
    private SSLContext sslContext;

    public JaxrsServer(Config config) {
    }

    public JaxrsServer withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public JaxrsServer withHttpPort(int port) {
        this.httpPort = port;
        return this;
    }

    public JaxrsServer withHttpsPort(int port, SSLContext sslContext) {
        this.sslContext = sslContext;
        this.httpsPort = port;
        return this;
    }

    public JaxrsServer start() {
        Undertow.Builder builder = Undertow.builder().setHandler((HttpHandler)this.root);
        if (this.httpPort != null) {
            builder.addHttpListener(this.httpPort.intValue(), this.hostname);
        }
        if (this.httpsPort != null) {
            builder.addHttpsListener(this.httpsPort.intValue(), this.hostname, this.sslContext);
        }
        LOG.info("Starting {}", (Object)this);
        this.server = builder.build();
        this.server.start();
        return this;
    }

    public JaxrsServer setHostname(String hostname) {
        return this.withHostname(hostname);
    }

    public JaxrsServer setPort(int port) {
        return this.withHttpPort(port);
    }

    public JaxrsServer deploy(Application application) {
        return this.deploy("/", application);
    }

    public JaxrsServer deploy(String contextPath, Application application) {
        super.deploy(application, contextPath);
        return this;
    }

    public JaxrsServer addPrefixPath(String path, HttpHandler handler) {
        this.root.addPrefixPath(path, handler);
        return this;
    }

    public String toString() {
        return String.format("JaxrsServer[host=%s, http=%d, https=%d, ssl=%s]", this.hostname, this.httpPort, this.httpsPort, this.sslContext);
    }
}

