/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.utils;

import io.nessus.common.AssertArg;
import io.nessus.common.AssertState;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;

public final class FileUtils {
    private FileUtils() {
    }

    public static boolean recursiveDelete(Path path) throws IOException {
        AssertArg.notNull(path, "Null path");
        if (path.toFile().exists()) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return !path.toFile().exists();
    }

    public static boolean recursiveCopy(final Path srcPath, final Path dstPath) throws IOException {
        AssertArg.notNull(srcPath, "Null srcPath");
        AssertArg.notNull(dstPath, "Null destPath");
        AssertState.isTrue(srcPath.toFile().exists(), "Does not exist: " + srcPath);
        Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relPath = srcPath.relativize(file);
                Path outPath = dstPath.resolve(relPath);
                outPath.getParent().toFile().mkdirs();
                Files.copy(file, outPath, new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
        return !dstPath.toFile().exists();
    }

    public static void atomicMove(Path srcPath, Path dstPath) throws IOException {
        FileUtils.recursiveDelete(dstPath);
        Files.move(srcPath, dstPath, StandardCopyOption.ATOMIC_MOVE);
    }
}

