/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public final class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;
    private static Set<Integer> alreadyUsed = new HashSet<Integer>();

    public static int getNextAvailable() {
        return AvailablePortFinder.getNextAvailable(1100);
    }

    public static int getNextAvailable(int fromPort) {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
        return AvailablePortFinder.getNextAvailable(addr, fromPort);
    }

    public static int getNextAvailable(InetAddress addr) {
        return AvailablePortFinder.getNextAvailable(addr, 1100);
    }

    public static int getNextAvailable(InetAddress addr, int fromPort) {
        if (fromPort < 1100 || fromPort > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + fromPort);
        }
        for (int i = fromPort; i <= 65535; ++i) {
            if (!AvailablePortFinder.available(addr, i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    public static synchronized boolean available(InetAddress addr, int port) {
        try (ServerSocket ss = new ServerSocket();){
            ss.setReuseAddress(false);
            ss.bind(new InetSocketAddress(addr, port));
        }
        catch (IOException e) {
            return false;
        }
        return alreadyUsed.add(port);
    }
}

