/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.common;

import io.nessus.common.AssertArg;
import io.nessus.common.AssertState;
import io.nessus.common.CheckedExceptionWrapper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Parameters {
    private static Map<Class<?>, ParameterDeserializer<?>> deserializers = new HashMap();
    private Map<String, Object> pmap = new LinkedHashMap<String, Object>();
    private boolean immutable;

    public Parameters() {
    }

    public Parameters(Map<String, ? extends Object> values) {
        this.pmap.putAll(values);
    }

    public Parameters(Parameters params) {
        this(params, false);
    }

    public Parameters(Parameters params, boolean immutable) {
        this.pmap.putAll(params.toMap());
        if (immutable) {
            this.pmap = Collections.unmodifiableMap(this.pmap);
            this.immutable = immutable;
        }
    }

    public static <T> void registerDeserializer(Class<T> type, ParameterDeserializer<T> deserializer) {
        deserializers.put(type, deserializer);
    }

    public boolean isEmpty() {
        return this.pmap.isEmpty();
    }

    public int size() {
        return this.pmap.size();
    }

    public List<String> keys() {
        return new ArrayList<String>(this.pmap.keySet());
    }

    public <T> T put(Class<T> type, T value) {
        return (T)this.pmap.put(this.toName(type), value);
    }

    public <T> T put(String name, T value) {
        Object res = value != null ? this.pmap.put(name, value) : this.pmap.remove(name);
        return (T)res;
    }

    public Parameters putAll(Parameters params) {
        this.putAll(params.toMap());
        return this;
    }

    public Parameters putAll(Map<String, Object> values) {
        this.pmap.putAll(values);
        return this;
    }

    public Parameters clear() {
        this.pmap.clear();
        return this;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Parameters makeImmutable() {
        return new Parameters(this, true);
    }

    public <T> T get(String name, Class<T> type) {
        Object value = this.pmap.get(name);
        value = this.convertValue(value, type);
        return (T)value;
    }

    public <T> T get(String name, T defaultValue) {
        AssertArg.notNull(defaultValue, "Null default value");
        Class<?> result = this.get(name, (T)defaultValue.getClass());
        return (T)(result != null ? result : defaultValue);
    }

    private <T> T convertValue(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            if (value.equals("[]")) {
                value = Collections.emptyList();
            }
            if (!(value instanceof List)) {
                String valstr = value.toString();
                if (valstr.startsWith("[") && valstr.endsWith("]")) {
                    valstr = valstr.substring(1, valstr.length() - 1);
                    String[] toks = valstr.split(",");
                    value = Arrays.asList(toks).stream().map(t -> t.trim()).collect(Collectors.toList());
                } else {
                    value = Arrays.asList(value);
                }
            }
            List vallst = value;
            List<Object> reslst = vallst.stream().map(el -> this.convertValue(el, compType)).collect(Collectors.toList());
            Object[] resarr = (Object[])Array.newInstance(compType, reslst.size());
            return (T)reslst.toArray(resarr);
        }
        if (value.equals("")) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        String strval = value.toString().trim();
        if (type == Boolean.class) {
            value = "0".equals(strval) ? Boolean.valueOf(false) : ("1".equals(strval) ? Boolean.valueOf(true) : Boolean.valueOf(strval));
        } else if (BigDecimal.class == type) {
            if (strval.endsWith("%")) {
                String auxval = strval.substring(0, strval.length() - 1);
                value = new BigDecimal(auxval).divide(new BigDecimal("100"));
            } else {
                value = new BigDecimal(strval);
            }
        } else if (Double.class == type) {
            if (strval.endsWith("%")) {
                String auxval = strval.substring(0, strval.length() - 1);
                value = Double.valueOf(auxval) / 100.0;
            } else {
                value = Double.valueOf(strval);
            }
        } else if (Integer.class == type) {
            value = new Integer(strval);
        } else if (Long.class == type) {
            value = new Long(strval);
        } else if (Path.class == type) {
            value = Paths.get(strval, new String[0]);
        } else if (URL.class == type) {
            try {
                value = new URL(strval);
            }
            catch (MalformedURLException ex) {
                throw CheckedExceptionWrapper.create(ex);
            }
        } else if (String.class == type) {
            value = strval;
        } else {
            ParameterDeserializer<?> des = deserializers.get(type);
            AssertState.notNull(des, "Unsupported type: " + type.getSimpleName());
            value = des.deserialize(strval);
        }
        return (T)value;
    }

    public <T> T notNull(String name, Class<T> type) {
        Class<T> value = this.get(name, (T)type);
        AssertState.notNull(value, "Cannot obtain parameter '" + name + "' from: " + this);
        return (T)value;
    }

    public <T> T remove(Class<T> type) {
        return (T)this.remove(this.toName(type));
    }

    public <T> T remove(String name, Class<T> type) {
        Class<T> resval = this.get(name, (T)type);
        this.pmap.remove(name);
        return (T)resval;
    }

    public Object remove(String name) {
        Class<Object> resval = this.get(name, (Object)Object.class);
        this.pmap.remove(name);
        return resval;
    }

    private String toName(Class<?> classKey) {
        return classKey.getSimpleName();
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.pmap);
    }

    public Map<String, Object> toMap(List<String> names) {
        Map<String, Object> result = this.pmap.entrySet().stream().filter(e -> names == null || names.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    public static Parameters fromString(String spec) {
        AssertArg.isTrue(spec.startsWith("{") && spec.endsWith("}"), "Invalid params spec: " + spec);
        spec = spec.substring(1, spec.length() - 1);
        Parameters params = new Parameters();
        if (spec.length() > 0) {
            Iterator<String> it = Arrays.asList(spec.split(",")).iterator();
            while (it.hasNext()) {
                String keyval = it.next();
                while (keyval.contains("=[") && !keyval.endsWith("]")) {
                    keyval = keyval + "," + it.next();
                }
                int idx = keyval.indexOf(61);
                String key = keyval.substring(0, idx).trim();
                String val = keyval.substring(idx + 1).trim();
                if (val.startsWith("[") && val.endsWith("]")) {
                    val = val.substring(1, val.length() - 1);
                    String[] valarr = val.split(",");
                    List vallst = Arrays.asList(valarr).stream().map(v -> v.trim()).collect(Collectors.toList());
                    params.put(key, vallst);
                    continue;
                }
                params.put(key, val);
            }
        }
        return params;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Parameters)) {
            return false;
        }
        Parameters other = (Parameters)obj;
        LinkedHashMap m1 = new LinkedHashMap();
        LinkedHashMap m2 = new LinkedHashMap();
        this.pmap.keySet().stream().sorted().forEach(k -> m1.put(k, this.pmap.get(k)));
        other.pmap.keySet().stream().sorted().forEach(k -> m2.put(k, other.pmap.get(k)));
        return ((Object)m1).toString().equals(((Object)m2).toString());
    }

    public String toString() {
        return this.pmap.toString();
    }

    public static interface ParameterDeserializer<T> {
        public T deserialize(String var1);
    }
}

