/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.utils;

public final class AssertState {
    private AssertState() {
    }

    public static <T> T assertNull(T value) {
        return AssertState.assertNull(value, "Not null: " + value);
    }

    public static <T> T assertNull(T value, String message) {
        if (value != null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static <T> T assertNotNull(T value) {
        return AssertState.assertNotNull(value, "Null value");
    }

    public static <T> T assertNotNull(T value, String message) {
        if (value == null) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static Boolean assertTrue(Boolean value) {
        return AssertState.assertTrue(value, "Not true");
    }

    public static Boolean assertTrue(Boolean value, String message) {
        if (!Boolean.valueOf(value).booleanValue()) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static Boolean assertFalse(Boolean value) {
        return AssertState.assertFalse(value, "Not false");
    }

    public static Boolean assertFalse(Boolean value, String message) {
        if (Boolean.valueOf(value).booleanValue()) {
            throw new IllegalStateException(message);
        }
        return value;
    }

    public static <T> T assertEquals(T exp, T was) {
        return AssertState.assertEquals(exp, was, exp + " != " + was);
    }

    public static <T> T assertEquals(T exp, T was, String message) {
        AssertState.assertNotNull(exp, message);
        AssertState.assertNotNull(was, message);
        AssertState.assertTrue(exp.equals(was), message);
        return was;
    }

    public static <T> T assertSame(T exp, T was) {
        return AssertState.assertSame(exp, was, exp + " != " + was);
    }

    public static <T> T assertSame(T exp, T was, String message) {
        AssertState.assertNotNull(exp, message);
        AssertState.assertNotNull(was, message);
        AssertState.assertTrue(exp == was, message);
        return was;
    }
}

