/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.cmd;

import io.nessus.cmd.CmdLineException;
import io.nessus.cmd.CmdLineTimeoutException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdLineClient {
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    static final String[] PATHS = new String[]{"/usr/bin/", "/usr/local/bin/"};

    public String exec(String cmdLine) {
        return this.exec(cmdLine, null, null);
    }

    public String exec(String cmdLine, Long timeout, TimeUnit unit) throws CmdLineTimeoutException {
        String result = null;
        try {
            String cmd = cmdLine.split(" ")[0];
            if (!cmd.startsWith("/")) {
                for (String aux : PATHS) {
                    if (!Paths.get(aux, cmd).toFile().exists()) continue;
                    cmdLine = aux + cmdLine;
                    break;
                }
            }
            this.LOG.debug("> {}", (Object)cmdLine);
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec(cmdLine);
            StreamGobbler stderr = new StreamGobbler(proc.getErrorStream());
            StreamGobbler stdout = new StreamGobbler(proc.getInputStream());
            stderr.start();
            stdout.start();
            if (timeout != null) {
                if (!proc.waitFor(timeout, unit)) {
                    String errmsg = "Timeout executing: " + cmdLine;
                    this.LOG.error(errmsg);
                    throw new CmdLineTimeoutException(errmsg);
                }
            } else {
                proc.waitFor();
            }
            if (proc.exitValue() != 0) {
                String errmsg;
                CmdLineException cause = null;
                if (stderr.length() > 0) {
                    errmsg = stderr.result();
                    cause = new CmdLineException(errmsg);
                }
                errmsg = "ERROR executing: " + cmdLine;
                if (cause != null) {
                    errmsg = errmsg + ", caused by: " + cause.getMessage();
                }
                this.LOG.error(errmsg);
                throw new CmdLineException(errmsg, cause);
            }
            result = stdout.result();
            this.LOG.debug(result);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }

    static class StreamGobbler
    extends Thread {
        final InputStream is;
        final StringWriter sw;

        StreamGobbler(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        public int length() {
            return this.sw.toString().length();
        }

        public String result() {
            return this.length() > 0 ? this.sw.toString().trim() : null;
        }

        @Override
        public void run() {
            try {
                String line = null;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                PrintWriter pw = new PrintWriter(this.sw);
                while ((line = br.readLine()) != null) {
                    pw.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

