/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.websocket;

import io.nessus.aries.AgentConfiguration;
import io.nessus.aries.util.AssertArg;
import io.nessus.aries.util.AssertState;
import io.nessus.aries.wallet.NessusWallet;
import io.nessus.aries.websocket.WebSocketListener;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.discover_features.DiscoverFeatureEvent;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueIndyCredentialEvent;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueLDCredentialEvent;
import org.hyperledger.aries.api.message.BasicMessage;
import org.hyperledger.aries.api.message.ProblemReport;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecord;
import org.hyperledger.aries.api.revocation.RevocationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEventV2;
import org.hyperledger.aries.api.revocation.RevocationRegistryState;
import org.hyperledger.aries.api.settings.Settings;
import org.hyperledger.aries.api.trustping.PingEvent;
import org.hyperledger.aries.webhook.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient {
    static final Logger log = LoggerFactory.getLogger(WebSocketClient.class);
    private final AgentConfiguration agentConfig;
    private final NessusWallet wallet;
    private WebSocketListener wslistener;
    private WebSocket webSocket;

    public WebSocketClient(AgentConfiguration agentConfig, NessusWallet wallet) {
        AssertArg.notNull(agentConfig, "No agentConfig");
        this.agentConfig = agentConfig;
        this.wallet = wallet;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public WebSocketListener getWebSocketListener() {
        return this.wslistener;
    }

    public void openWebSocket(WebSocketListener listener) {
        AssertArg.notNull(listener, "No listener");
        Request.Builder b = new Request.Builder();
        b.url(this.agentConfig.getWebSocketUrl());
        if (this.agentConfig.getApiKey() != null) {
            b.header("X-API-Key", this.agentConfig.getApiKey());
        }
        if (this.wallet != null && this.wallet.getToken() != null) {
            b.header("Authorization", "Bearer " + this.wallet.getToken());
        }
        Request request = b.build();
        OkHttpClient httpClient = new OkHttpClient();
        this.webSocket = httpClient.newWebSocket(request, (okhttp3.WebSocketListener)listener);
        this.wslistener = listener;
    }

    public void close() {
        if (this.webSocket != null) {
            this.webSocket.close(1001, null);
            this.webSocket = null;
        }
    }

    public WebSocketClient startRecording(EventType ... evtypes) {
        AssertState.notNull(this.wslistener, "Not connected");
        this.wslistener.startRecording(evtypes);
        return this;
    }

    public WebSocketClient retartRecording(EventType ... evtypes) {
        AssertState.notNull(this.wslistener, "Not connected");
        this.wslistener.startRecording(evtypes);
        return this;
    }

    public WebSocketClient stopRecording(EventType ... evtypes) {
        AssertState.notNull(this.wslistener, "Not connected");
        this.wslistener.stopRecording(evtypes);
        return this;
    }

    public Stream<BasicMessage> awaitBasicMessage(Predicate<BasicMessage> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitBasicMessage(predicate, timeout, unit);
    }

    public Stream<ConnectionRecord> awaitConnection(Predicate<ConnectionRecord> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitConnection(predicate, timeout, unit);
    }

    public Stream<DiscoverFeatureEvent> awaitDiscoveredFeature(Predicate<DiscoverFeatureEvent> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitDiscoveredFeature(predicate, timeout, unit);
    }

    public Stream<EndorseTransactionRecord> awaitEndorseTransaction(Predicate<EndorseTransactionRecord> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitEndorseTransaction(predicate, timeout, unit);
    }

    public Stream<V1CredentialExchange> awaitIssueCredentialV1(Predicate<V1CredentialExchange> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitIssueCredentialV1(predicate, timeout, unit);
    }

    public Stream<V20CredExRecord> awaitIssueCredentialV2(Predicate<V20CredExRecord> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitIssueCredentialV2(predicate, timeout, unit);
    }

    public Stream<V2IssueIndyCredentialEvent> awaitIssueCredentialV2Indy(Predicate<V2IssueIndyCredentialEvent> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitIssueCredentialV2Indy(predicate, timeout, unit);
    }

    public Stream<V2IssueLDCredentialEvent> awaitIssueCredentialV2LD(Predicate<V2IssueLDCredentialEvent> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitIssueCredentialV2LD(predicate, timeout, unit);
    }

    public Stream<RevocationEvent> awaitIssuerRevocation(Predicate<RevocationEvent> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitIssuerRevocation(predicate, timeout, unit);
    }

    public Stream<PresentationExchangeRecord> awaitPresentProofV1(Predicate<PresentationExchangeRecord> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitPresentProofV1(predicate, timeout, unit);
    }

    public Stream<V20PresExRecord> awaitPresentProofV2(Predicate<V20PresExRecord> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitPresentProofV2(predicate, timeout, unit);
    }

    public Stream<ProblemReport> awaitProblemReport(Predicate<ProblemReport> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitProblemReport(predicate, timeout, unit);
    }

    public Stream<RevocationNotificationEvent> awaitRevocationNotificationV1(Predicate<RevocationNotificationEvent> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitRevocationNotificationV1(predicate, timeout, unit);
    }

    public Stream<RevocationNotificationEventV2> awaitRevocationNotificationV2(Predicate<RevocationNotificationEventV2> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitRevocationNotificationV2(predicate, timeout, unit);
    }

    public Stream<RevocationRegistryState> awaitRevocationRegistry(Predicate<RevocationRegistryState> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitRevocationRegistry(predicate, timeout, unit);
    }

    public Stream<Settings> awaitSettings(Predicate<Settings> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitSettings(predicate, timeout, unit);
    }

    public Stream<PingEvent> awaitTrustPing(Predicate<PingEvent> predicate, long timeout, TimeUnit unit) {
        AssertState.notNull(this.wslistener, "Not connected");
        return this.wslistener.awaitTrustPing(predicate, timeout, unit);
    }
}

