/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.wallet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class WalletConfigurations {
    static final Logger log = LoggerFactory.getLogger(WalletConfigurations.class);
    private Map<String, WalletConfig> configs = new LinkedHashMap<String, WalletConfig>();

    private WalletConfigurations() {
    }

    public static WalletConfigurations loadWalletConfigurations() throws IOException {
        String home = System.getProperty("user.home");
        File infile = new File(home + "/.config/aries-cli/config.yaml");
        if (!infile.isFile()) {
            throw new FileNotFoundException(infile.getAbsolutePath());
        }
        FileInputStream fis = new FileInputStream(infile);
        Yaml yaml = new Yaml();
        WalletConfigurations result = new WalletConfigurations();
        Map loaded = (Map)yaml.load((InputStream)fis);
        loaded = (Map)loaded.get("configurations");
        for (Map.Entry en : loaded.entrySet()) {
            Map val = (Map)en.getValue();
            result.configs.put(((String)en.getKey()).toLowerCase(), new WalletConfig((String)en.getKey(), (String)val.get("endpoint"), (String)val.get("api_key"), (String)val.get("auth_token")));
        }
        return result;
    }

    public WalletConfig getWalletConfig(String name) {
        return this.configs.get(name.toLowerCase());
    }

    public static class WalletConfig {
        public final String name;
        public final String endpoint;
        public final String api_key;
        public final String auth_token;

        WalletConfig(String name, String endpoint, String api_key, String auth_token) {
            this.name = name;
            this.endpoint = endpoint;
            this.api_key = api_key;
            this.auth_token = auth_token;
        }
    }
}

