/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.util;

import io.nessus.aries.util.AssertArg;
import io.nessus.aries.util.AttachmentKey;
import io.nessus.aries.util.Attachments;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AttachmentSupport
implements Attachments {
    private Map<AttachmentKey<? extends Object>, Object> attachments;

    @Override
    public synchronized Set<AttachmentKey<?>> getAttachmentKeys() {
        if (this.attachments == null) {
            return Collections.emptySet();
        }
        return this.attachments.keySet();
    }

    @Override
    public synchronized <T> T putAttachment(AttachmentKey<T> key, T value) {
        AssertArg.notNull(key, "Null key");
        if (this.attachments == null) {
            this.attachments = new HashMap<AttachmentKey<? extends Object>, Object>();
        }
        return (T)(value != null ? this.attachments.put(key, value) : this.attachments.remove(key));
    }

    @Override
    public void putAllAttachments(Attachments source) {
        source.getAttachmentKeys().forEach(key -> {
            AttachmentKey typedKey = key;
            this.putAttachment(typedKey, source.getAttachment(key));
        });
    }

    @Override
    public synchronized <T> T getAttachment(AttachmentKey<T> key) {
        AssertArg.notNull(key, "Null key");
        return (T)(this.attachments != null ? this.attachments.get(key) : null);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key, T defaultValue) {
        T value = this.getAttachment(key);
        if (value == null) {
            value = defaultValue;
            this.putAttachment(key, value);
        }
        return value;
    }

    @Override
    public synchronized <T> boolean hasAttachment(AttachmentKey<T> key) {
        AssertArg.notNull(key, "Null key");
        return this.attachments != null ? this.attachments.containsKey(key) : false;
    }

    @Override
    public synchronized <T> T removeAttachment(AttachmentKey<T> key) {
        AssertArg.notNull(key, "Null key");
        return (T)(this.attachments != null ? this.attachments.remove(key) : null);
    }
}

