/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.stability;

import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.examples.benchmark.Utils;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;

public class StabilityPub {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.StabilityPub [server] <subject> <msgSize>\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n";

    public static void main(String[] args) {
        int msgSize;
        String subject;
        String server;
        long messageCount = 0L;
        long payloadCount = 0L;
        if (args.length == 3) {
            server = args[0];
            subject = args[1];
            msgSize = Integer.parseInt(args[2]);
        } else if (args.length == 2) {
            server = "nats://localhost:4222";
            subject = args[0];
            msgSize = Integer.parseInt(args[1]);
        } else {
            StabilityPub.usage();
            return;
        }
        try {
            Options options = new Options.Builder().server(server).noReconnect().build();
            Connection nc = Nats.connect(options);
            Instant start = Instant.now();
            byte[] payload = new byte[msgSize];
            System.out.println("Running stability publisher for indefinite test, ctrl-c to cancel...\n");
            while (true) {
                nc.publish(subject, payload);
                payloadCount += (long)msgSize;
                if (++messageCount != 0L && messageCount % 1000L == 0L) {
                    nc.flush(Duration.ofSeconds(30L));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (messageCount == 0L || messageCount % 100000L != 0L) continue;
                Instant finish = Instant.now();
                System.out.printf("Running for %s\n", Duration.between(start, finish).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase());
                System.out.printf("Sent %s messages.\n", NumberFormat.getIntegerInstance().format(messageCount));
                System.out.printf("Sent %s payload bytes.\n", Utils.humanBytes(payloadCount));
                System.out.printf("Current memory usage is %s / %s / %s free/total/max\n", Utils.humanBytes(Runtime.getRuntime().freeMemory()), Utils.humanBytes(Runtime.getRuntime().totalMemory()), Utils.humanBytes(Runtime.getRuntime().maxMemory()));
                System.out.println();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    static void usage() {
        System.err.println(usageString);
        System.exit(-1);
    }
}

