/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;

public class SubjectsMultiWildcard {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            CountDownLatch latch = new CountDownLatch(3);
            Dispatcher dMulti = nc.createDispatcher(msg -> {
                latch.countDown();
                System.out.println("Received weather for " + msg.getSubject() + " --> " + new String(msg.getData(), StandardCharsets.UTF_8));
            });
            dMulti.subscribe("weather.>");
            byte[] data = "US weather update".getBytes(StandardCharsets.UTF_8);
            nc.publish("weather.us", data);
            data = "East coast update".getBytes(StandardCharsets.UTF_8);
            nc.publish("weather.us.east", data);
            data = "Finland weather".getBytes(StandardCharsets.UTF_8);
            nc.publish("weather.eu.north.finland", data);
            System.out.println("Waiting for messages...");
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

