/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;

public class SubjectsMonitoring {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            CountDownLatch latch = new CountDownLatch(3);
            Dispatcher dEverything = nc.createDispatcher(msg -> {
                latch.countDown();
                System.out.println("[MONITOR] " + msg.getSubject() + " --> " + new String(msg.getData(), StandardCharsets.UTF_8));
            });
            dEverything.subscribe(">");
            nc.publish("hello", "Hello NATS!".getBytes(StandardCharsets.UTF_8));
            nc.publish("event.new", "click".getBytes(StandardCharsets.UTF_8));
            nc.publish("weather.north.fr", "Temperature: 11\u00b0C".getBytes(StandardCharsets.UTF_8));
            System.out.println("Waiting for messages...");
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

