/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestReplyNoResponders {
    public static void main(String[] args) {
        Options options = Options.builder().server("nats://localhost:4222").reportNoResponders().build();
        try (Connection nc = Nats.connect(options);){
            CompletableFuture<Message> responseFuture = nc.request("no.such.service", null);
            try {
                Message m = responseFuture.get(500L, TimeUnit.MILLISECONDS);
                System.out.println("Response: " + new String(m.getData()));
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                System.out.println("No Response: " + e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

